!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: abschar.gs,v 1.7 2008-01-09 22:50:07 stever Exp $
!
! Superclass Hierarchy:
!   AbstractCharacter, Magnitude, Object.
!
!=========================================================================

removeallmethods AbstractCharacter
removeallclassmethods AbstractCharacter

category: 'For Documentation Installation only'
classmethod: AbstractCharacter
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'AbstractCharacter is an abstract superclass that defines behavior common to
 one-byte and two-byte character classes.  Its concrete subclasses include
 Character and JISCharacter.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Non-Printable Characters'
classmethod: AbstractCharacter
backspace

"(Subclass responsibility.)  Returns the back-space character from the
 receiver's character set."

AbstractCharacter subclassResponsibility: #backspace
%

category: 'Non-Printable Characters'
classmethod: AbstractCharacter
cr

"(Subclass responsibility.)  Returns the carriage-return character from the
 receiver's character set."

AbstractCharacter subclassResponsibility: #cr
%

category: 'Non-Printable Characters'
classmethod: AbstractCharacter
esc

"(Subclass responsibility.)  Returns the escape character from the receiver's
 character set."

AbstractCharacter subclassResponsibility: #esc
%

category: 'Non-Printable Characters'
classmethod: AbstractCharacter
lf

"(Subclass responsibility.)  Returns the line-feed character from the receiver's
 character set."

AbstractCharacter subclassResponsibility: #lf
%

category: 'Non-Printable Characters'
classmethod: AbstractCharacter
newPage

"(Subclass responsibility.)  Returns the new-page character from the receiver's
 character set."

AbstractCharacter subclassResponsibility: #newPage
%

category: 'Non-Printable Characters'
classmethod: AbstractCharacter
space

"(Subclass responsibility.)  Returns the space character from the receiver's
 character set."

AbstractCharacter subclassResponsibility: #space
%

category: 'Non-Printable Characters'
classmethod: AbstractCharacter
tab

"(Subclass responsibility.)  Returns the tab character from the receiver's
 character set."

AbstractCharacter subclassResponsibility: #tab
%

category: 'Instance Creation'
classmethod: AbstractCharacter
fromStream: aStream

"(Subclass responsibility.)  Returns an instance of the receiver's class that is
 the next character in the stream, aStream."

AbstractCharacter subclassResponsibility: #fromStream:
%

category: 'Instance Creation'
classmethod: AbstractCharacter
withValue: anInteger

"(Subclass responsibility.)  Returns an instance of the receiver's class that
 has the specified internal value."

AbstractCharacter subclassResponsibility: #withValue:
%

category: 'Testing'
method: AbstractCharacter
isDigit

"(Subclass responsibility.)  Returns true if the receiver is a digit.  Returns
 false otherwise."

AbstractCharacter subclassResponsibility: #isDigit
%

category: 'Testing'
method: AbstractCharacter
isEquivalent: aCharacter

"(Subclass responsibility.)  Returns true if the receiver is equivalent to
 aCharacter.  The receiver is equivalent to aCharacter if the receiver is the
 same character as the argument regardless of case or internal representation."

AbstractCharacter subclassResponsibility: #isEquivalent:
%

category: 'Testing'
method: AbstractCharacter
isLowercase

"(Subclass responsibility.)  Returns true if the receiver is a lower-case
 character.  Returns false otherwise."

AbstractCharacter subclassResponsibility: #isLowercase
%

category: 'Testing'
method: AbstractCharacter
isUppercase

"(Subclass responsibility.)  Returns true if the receiver is an upper-case
 character.  Returns false otherwise."

AbstractCharacter subclassResponsibility: #isUppercase
%

category: 'Formatting'
method: AbstractCharacter
displayWidth

"(Subclass responsibility.)  Returns the width necessary to display the
 receiver."

AbstractCharacter subclassResponsibility: #displayWidth
%

category: 'Converting'
method: AbstractCharacter
digitValue

"(Subclass responsibility.)  Returns a SmallInteger representing the value of
 the receiver, a digit, or returns nil if the receiver is not a digit."

AbstractCharacter subclassResponsibility: #digitValue
%

category: 'Converting'
method: AbstractCharacter
asCharacter

"(Subclass responsibility.)  Returns the Character corresponding to the
 receiver."

AbstractCharacter subclassResponsibility: #asCharacter
%

category: 'Converting'
method: AbstractCharacter
asInteger

"(Subclass responsibility.)  Returns the internal code of the receiver."

AbstractCharacter subclassResponsibility: #asInteger
%

category: 'Converting'
method: AbstractCharacter
asJISCharacter

"(Subclass responsibility.)  Returns the JISCharacter corresponding to the
 receiver."

AbstractCharacter subclassResponsibility: #asJISCharacter
%

category: 'Converting'
method: AbstractCharacter
asLowercase

"(Subclass responsibility.)  Returns a kind of AbstractCharacter that is the
 lower-case character corresponding to the receiver.  If the receiver
 is lower-case or has no case, this returns the receiver itself."

AbstractCharacter subclassResponsibility: #asLowercase
%

category: 'Converting'
method: AbstractCharacter
asUppercase

"(Subclass responsibility.)  Returns a kind of AbstractCharacter that is the
 upper-case character corresponding to the receiver.  If the receiver
 is upper-case or has no case, this returns the receiver itself."

AbstractCharacter subclassResponsibility: #asUppercase
%

category: 'Comparing'
method: AbstractCharacter
<= aCharacter

"Returns true if the receiver is less than or equal to the argument,
 otherwise returns false."

^ (self < aCharacter) _or: [self = aCharacter]
%

category: 'Comparing'
method: AbstractCharacter
> aCharacter

"Returns true if the receiver is greater than the argument,
 otherwise returns false."

^ (self <= aCharacter) not
%

category: 'Comparing'
method: AbstractCharacter
>= aCharacter

"Returns true if the receiver is greater than the argument,
 otherwise returns false."

^ (self < aCharacter) not
%

category: 'Comparing'
method: AbstractCharacter
hash

"Returns a numeric hash key for the receiver."

^self asInteger
%
category: 'Other Comparisons'
method: AbstractCharacter
asciiLessThan: aChar

"Returns true if the ASCII code of the receiver is less than that of
 aCharacter."

^ self asciiValue < aChar asciiValue

%
category: 'New Indexing Comparison'
method: AbstractCharacter
_classSortOrdinal

^ 30
%
