!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: btreecompforcompare.gs,v 1.4 2008-01-09 22:50:08 stever Exp $
!
! Superclass Hierarchy:
!   BtreeComparisonForCompare, Object.
!
!=========================================================================

! class created in idxclasses.topaz

category: 'For Documentation Installation only'
removeallmethods BtreeComparisonForCompare
removeallclassmethods BtreeComparisonForCompare

classmethod: BtreeComparisonForCompare
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'During btree sort and compare operations (for BtreeNode and subclasses) the exact method
 senf for doing comparison operations varies depending upon whether the comparison is for 
 a sort or a query (compare). The class translates the message into a variant for comparing.'.
doc documentClassWith: txt.

self description: doc.
%
! ------------------- Class methods for BtreeComparisonForCompare
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey equalTo: aValue

^ aKey _idxForCompareEqualTo: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey greaterThan: aValue

^ aKey _idxForCompareGreaterThan: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey greaterThanOrEqualTo: aValue

^ aKey _idxForCompareGreaterThanOrEqualTo: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey lessThan: aValue

^ aKey _idxForCompareLessThan: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey lessThanOrEqualTo: aValue

^ aKey _idxForCompareLessThanOrEqualTo: aValue
%
category: 'Testing'
classmethod: BtreeComparisonForCompare
satisfiableQueryGreaterThan: val1 
andEquals: bool1
andLessThan: val2 
andEquals: bool2

  ^ ( (val1 _idxForCompareGreaterThan: val2) _or:
       [ val1 = val2 _and: [ (bool1 & bool2) not ] ] ) not
%
! ------------------- Instance methods for BtreeComparisonForCompare
