!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: canonstringbucket.gs,v 1.8 2008-01-09 22:50:08 stever Exp $
!
! Superclass Hierarchy:
!   CanonStringBucket, AbstractCollisionBucket, 
!   Array, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

expectvalue %String
run
AbstractCollisionBucket _newKernelSubclass: #CanonStringBucket
  instVarNames: #( keyValueDictionary)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[  ]
  instancesInvariant: false
  isModifiable: false
  reservedOop: 931 
%

expectvalue true
run
CanonStringBucket _disallowGciCreateStore .
^ true
%


removeallmethods CanonStringBucket
removeallclassmethods CanonStringBucket

category: 'For Documentation Installation only'
classmethod: CanonStringBucket
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A CanonStringBucket is an Array that is used in a 
 CanonSymbolsDictionary .  It contains keys which have the same String
 hash value , and is sorted by value comparision of the keys.
 The comparision is done using binary comparison of the bytes of the keys.
 The hash value must be computed by using CanonStringDict >> hashFunction:' . 
doc documentClassWith: txt.

txt := (GsDocText new) details:
'An AbstractDictionary.  For GemStone internal use.' .
doc documentInstVar: #keyValueDictionary with: txt.

self description: doc.
%


!---------------------------------------
category: 'Accessing'
! at: 		inherited from AbstractCollisionBucket
! at:ifAbsent:  inherited
! at:otherwise: inherited

! fix 31083
method: CanonStringBucket
keyAt: index

"Returns the key at the specified index."

^ self _at: index 
%

! keyAt:otherwise:  	inherited

method: CanonStringBucket
keyValueDictionary

"Returns the value of the instance variable."

^keyValueDictionary
%

! numElements  		inherited
! size 			inherited

method: CanonStringBucket
tableSize

"Returns the number of keys in the capacity of the receiver."

^self _basicSize
%

method: CanonStringBucket
valueAt: index

"not supported, instances hold only keys"

self shouldNotImplement: #valueAt: 
%

! _reportKeyNotFound:with:	inherited

!---------------------------------------
category: 'Adding'
method: CanonStringBucket
add: anAssociation

"Disallowed, CanonStringBucket does not contain associations"

self shouldNotImplement: #add:
%

!---------------------------------------
! category: 'Backward Compatibility'
!  doKeys:  		inherited
!  doValues:   		inherited
! category: 'Error Handling'
!   _errorKeyNotFound:	inherited
! category: 'Formatting'
!   printOn:		inherited
! category: 'Initializing'
!  initialize		inherited

!---------------------------------------
category: 'Private'
!  compareKey:with:	inherited

method: CanonStringBucket
_removeAll

"Dereferences the receiver from its parent and shrinks the receiver.
 Used while rebuilding a dictionary."

keyValueDictionary := nil.
numElements := 0.
self size: 0
%

! ---------------------------------------
! category: 'Removing'

method: CanonStringBucket
removeKey: aKey ifAbsent: aBlock

"Removes the specified key and returns aKey . If aKey is not found,
 returns the result of evaluating the zero-argument block aBlock."

 | keyIndex |
 keyIndex := self searchForKey: aKey.
 keyIndex == nil
 ifFalse: [
    numElements := numElements - 1.
    self _deleteNoShrinkFrom: keyIndex to: keyIndex .
    ^ aKey 
    ]
 ifTrue: [ ^ self _reportKeyNotFound: aKey with: aBlock ]
%


!---------------------------------------
category: 'Searching'
!   firstPair		inherited
!  includesKey:		inherited

method: CanonStringBucket
searchForKey: aKey

"Returns the index of aKey, or if not found, nil."

<primitive: 471>
aKey _validateClass: String  .
self _primitiveFailed: #searchForKey: .
self _uncontinuableError
%

!---------------------------------------
category: 'Updating'
!  at:put: 		inherited

method: CanonStringBucket
at: aKey put: aValue keyValDict: aKeyValDict

"key-value pairs are not supported"

^ self shouldNotImplement: #at:put:keyValDict:
%
method: CanonStringBucket
at: aKey put: aValue keyValDict_coll: aKeyValDict

"key-value pairs are not supported"

^ self shouldNotImplement: #at:put:keyValDict_coll:
%

method: CanonStringBucket
addKey: aKey

"All additions should be done via methods in the parent dictionary."

^ self shouldNotImplement: #addKey:
%

method: CanonStringBucket
at: anIndex putKey: aKey

"Disallowed, must use addKey:  or removeKey:"

self shouldNotImplement: #at:putKey: .
%

method: CanonStringBucket
at: anIndex putValue: aValue

"Disallowed, must use addKey:  or removeKey:"

self shouldNotImplement: #at:putValue: .
%

method: CanonStringBucket
keyValueDictionary: aDict

"Updates the value of the keyValueDictionary instance variable."

keyValueDictionary := aDict
%

! additions to fix 31544 , keysDo: valuesDo: keysAndValuesDo:
category: 'Enumerating'
method: CanonStringBucket
keysDo: aBlock

"For each key/value pair in the receiver, evaluates the one-argument block
 aBlock with the key as the argument.  Returns the receiver."

1 to: numElements do:[:idx | aBlock value: ( self _at: idx )  ] .
%

category: 'Enumerating'
method: CanonStringBucket
valuesDo: aBlock

"For each key/value pair in the receiver, evaluates the one-argument block
 aBlock with the value as the argument.  Returns the receiver."

 self keysDo: aBlock
%

category: 'Enumerating'
method: CanonStringBucket
keysAndValuesDo: aBlock

"For each key/value pair in the receiver, evaluates the two-argument block
 aBlock with the arguments key, value.  Returns the receiver."

1 to: numElements do:[:idx | | aSym |
   aSym := self _at: idx  .
   aBlock value: aSym value: aSym 
].
%
! added for 36675
category: 'Enumerating'
method: CanonStringBucket
inject: anObj keysAndValuesInto: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 2nd and 3rd arguments.  
 aBlock must be a 3 argument block, with arguments anObj, key value ."

1 to: numElements do:[:idx | | aSym |
   aSym := self _at: idx  .
   aBlock value: anObj value: aSym value: aSym
].
%



!---------------------------------------
! class methods
category: 'Instance Creation'
!  new		inherited
!  new:		inherited

