!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: eucsymbol.gs,v 1.5 2008-01-09 22:50:10 stever Exp $
!
! Superclass Hierarchy:
!   EUCSymbol, InvariantEUCString, EUCString, JapaneseString,
!   CharacterCollection, SequenceableCollection, Collection, Object.
!
!=========================================================================

removeallmethods EUCSymbol
removeallclassmethods EUCSymbol

category: 'For Documentation Installation only'
classmethod: EUCSymbol
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'An EUCSymbol represents an invariant Japanese symbol in Extended Unix Code
 format. 

 EUCSymbols are not canonicalized like Symbol and DoubleByteSymbol.

 An EUCSymbol may not be used as a message selector, and may not be stored
 into an instance variable constrained to hold Symbols.'.
doc documentClassWith: txt.

self description: doc.
%

! removed isSymbol to fix 32218

! category: 'Formatting'
! method: EUCSymbol
! describe
! 
! "Describes the receiver as a literal symbol."
! 
! ^(EUCString withAll: '#') addAll: self
! %

category: 'Formatting'
method: EUCSymbol
printOn: aStream

"Puts a displayable representation of the receiver on the given stream.
 That representation conforms to GemStone Smalltalk parsing rules."

| mySize |
(mySize := self size) == 0 ifTrue:[
  aStream nextPut: $# .
  aStream nextPut: $' .
  aStream nextPut: $' .
  ]
ifFalse:[
  "do it the efficient way for large Symbols"
  aStream nextPut: $# .
  super printOn: aStream 
  ]
%

! asSymbolKind deleted
