!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: gsintersessignal.gs,v 1.4 2008-01-09 22:50:11 stever Exp $
!
! Superclass Hierarchy:
!   GsInterSessionSignal, Object
!=========================================================================
expectvalue %String
run
^ Object _newKernelSubclass: 'GsInterSessionSignal'
        instVarNames: #( 'sessionSerialNum' 'signal' 'message' )
        classVars: #()
        classInstVars: #()
        poolDictionaries: #[]
        inDictionary: Globals
        constraints: #[ #[ #sessionSerialNum, SmallInteger ],
		        #[ #signal, SmallInteger ],
			#[ #message, String ] ]
        instancesInvariant: false
        isModifiable: false
        reservedOop: 821
%

removeallmethods  GsInterSessionSignal
removeallclassmethods  GsInterSessionSignal

category: 'For Documentation Installation only'
classmethod: GsInterSessionSignal
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A GsInterSessionSignal represents a signal from one session to another within
 a single GemStone system.' .
doc documentClassWith: txt.

txt := (GsDocText new) details:
'A SmallInteger identifier of the session from which the instance was received.
 To obtain the corresponding session, use the method
 GsSession | sessionWithSerialNumber:.' .
doc documentInstVar: #sessionSerialNum with: txt.

txt := (GsDocText new) details:
'A SmallInteger representing application-defined information from the sending
 session.' .
doc documentInstVar: #signal with: txt .

txt := (GsDocText new) details:
'A String representing application-defined information from the sending
 session.' .
doc documentInstVar: #message with: txt .

self description: doc.
%

category: 'Instance Creation'
classmethod: GsInterSessionSignal
signal: aSignal message: aString 

"Returns a new instance with the given information installed.  
 The originating GsSession is set to nil."

| result |
result := super new.
result signal: aSignal; message: aString.
^ result
%

category: 'Accessing'
method: GsInterSessionSignal
session 

"Returns a transient GsSession object representing the session that sent the
 signal, or nil if there was no signal.  This object can be used as target of
 signals sent in response."

^ GsSession sessionWithSerialNumber: sessionSerialNum
%

category: 'Accessing'
method: GsInterSessionSignal
session: aGsSession 

"Sets the session instance variable so that it represents the session that sent
 the signal."

sessionSerialNum := aGsSession sessionSerialNum
%

category: 'Accessing'
method: GsInterSessionSignal
signal 

"Returns the SmallInteger sent as a signal."

^ signal
%

category: 'Accessing'
method: GsInterSessionSignal
signal: aSmallInteger 

"Sets the SmallInteger to be sent as a signal."

signal := aSmallInteger
%

category: 'Accessing'
method: GsInterSessionSignal
message 

"Returns the String sent as a message."

^ message
%

category: 'Accessing'
method: GsInterSessionSignal
message: aString 

"Sets the String to be sent as a message."

message := aString asString

%

category: 'Signalling'
method: GsInterSessionSignal
replyToSenderWithSignal: aSmallInteger withString: aString 

"Sends a signal containing the arguments to the originating session of the
 receiver.  If the session instance variable of the receiver is nil, raises an
 error."

System _sendSignal: aSmallInteger toSess: sessionSerialNum 
	withMessage: aString
%

category: 'Signalling'
method: GsInterSessionSignal
sendToSession: aGsSession 

"Sends a signal to the session represented by aGsSession.  The signal contains
 the signal and message instance variables of the receiver.  Ignores the session
 instance variable of the receiver."

aGsSession sendSignalObject: self 
%

