!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: largene.gs,v 1.7 2008-01-09 22:50:12 stever Exp $
!
! Superclass Hierarchy:
!   LargeNegativeInteger, Integer, Number, Magnitude, Object.
!
!=========================================================================

removeallmethods LargeNegativeInteger
removeallclassmethods LargeNegativeInteger

category: 'For Documentation Installation only'
classmethod: LargeNegativeInteger
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'Instances of LargeNegativeInteger represent negative integers whose values are
 less than the minimum SmallInteger ((2 to the 29th power)).  Each instance of
 LargeNegativeInteger is stored as an Array of bytes, where each
 double-byte pair represents a base 32768 digit.  The first two bytes in that
 Array constitute the least significant base 32768 digit, and the last two 
 bytes are the most significant base 32768 digit.  Within each digit, the
 least significant byte is first, followed by the more significant byte.

 Coercion between LargeNegativeInteger and SmallInteger occurs automatically.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Accessing'
method: LargeNegativeInteger
at: anIndex

"Disallowed."

self shouldNotImplement: #at:
%

category: 'Accessing'
method: LargeNegativeInteger
at: anIndex put: aNumber

"Disallowed.  You may not change the value of a LargeNegativeInteger."

self shouldNotImplement: #at:put:
%

category: 'Testing'
method: LargeNegativeInteger
negative

"Returns true."

^true
%

category: 'Testing'
method: LargeNegativeInteger
positive

"Returns false."

^false
%

category: 'Truncation and Rounding'
method: LargeNegativeInteger
truncated

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%

category: 'Arithmetic'
method: LargeNegativeInteger
abs

"Returns a LargePositiveInteger that is the absolute value of the receiver."

^self negated
%

! Gs64 v2.0, delete method  negated  , now inherited from Number

category: 'Bit Manipulation'
method: LargeNegativeInteger
highBit

"Returns the index of the high-order bit that is set in the binary
 representation of the receiver.  (Because the receiver is a negative integer,
 this method takes its absolute value first.)"

^(self negated) highBit
%

! following calls to prim 599 added to handle sub-normal large integers
category: 'Converting'
method: LargeNegativeInteger
asInteger

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%

category: 'Truncation and Rounding'
method: LargeNegativeInteger
ceiling

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%
category: 'Truncation and Rounding'
method: LargeNegativeInteger
floor

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%

category: 'Truncation and Rounding'
method: LargeNegativeInteger
rounded

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%


category: 'Repository Conversion'
method: LargeNegativeInteger
needsFixingAfterConversion
^true
%
