!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: rcbtreebasicinter.gs,v 1.4 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   RcBtreeBasicInteriorNode, BtreeBasicInteriorNode, BtreeInteriorNode, BtreeNode, Array,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods RcBtreeBasicInteriorNode
removeallclassmethods RcBtreeBasicInteriorNode

category: 'For Documentation Installation only'
classmethod: RcBtreeBasicInteriorNode
installDocumentation

| doc txt |
doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
'A RcBtreeBasicInteriorNode represents an interior node of a B-tree for which a
 binary search can be done for a key. Updates to instances of this class are 
 logged and can  be replayed in the case of commit conflicts.' .
doc documentClassWith: txt.

self description: doc.
%

! ------------------- Class methods for RcBtreeBasicInteriorNode
! ------------------- Instance methods for RcBtreeBasicInteriorNode
category: 'Updating'
method: RcBtreeBasicInteriorNode
at: aKey put: aValue

self shouldNotImplement: #at:put:
%
category: 'Updating'
method: RcBtreeBasicInteriorNode
btreeAt: aKey put: aValue

""

self shouldNotImplement: #btreeAt:put:
%
category: 'Updating'
method: RcBtreeBasicInteriorNode
btreeAt: aKey put: aValue for: anIndexObj logging: aBoolean

| res |
res := self _at: aKey put: aValue for: anIndexObj logging: aBoolean.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
category: 'Constants'
method: RcBtreeBasicInteriorNode
parentNodeClass

"Returns the class of node to be created as the parent when a split occurs."

^ RcBtreeBasicInteriorNode
%
category: 'Removing'
method: RcBtreeBasicInteriorNode
removeKey: aKey value: aValue

self shouldNotImplement: #removeKey:value:
%
category: 'Removing'
method: RcBtreeBasicInteriorNode
removeKey: aKey value: aValue for: anIndexObj logging: aBoolean

| res |
res := self _removeKey: aKey value: aValue for: anIndexObj logging: aBoolean.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
