!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: stream.gs,v 1.4 2008-01-09 22:50:19 stever Exp $
!
! Superclass Hierarchy:
!   Stream, Object.
!
!=========================================================================

removeallmethods Stream
removeallclassmethods Stream

category: 'For Documentation Installation only'
classmethod: Stream
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'Stream is an abstract superclass that represents the ability to maintain a
 position reference into a linear sequence of objects.  Concrete subclasses are
 ReadStream and WriteStream.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Enumerating'
method: Stream
do: aBlock

"Evaluates the one-argument block aBlock for each of the remaining objects that
 the receiver can access."

[self atEnd]
  whileFalse: [aBlock value: self next]
%

category: 'Accessing'
method: Stream
next

"(Subclass responsibility, ReadStream only.)  Returns the next object that the
 receiver can access for reading.  Generates an error if an attempt is made to
 read beyond the end of the stream."

Stream subclassResponsibility: #next
%

category: 'Testing'
method: Stream
atEnd

"(Subclass responsibility.)  Returns true if the receiver cannot access any more
 objects, false if it can."

Stream subclassResponsibility: #atEnd
%

category: 'Adding'
method: Stream
nextPut: anObject

"(Subclass responsibility, WriteStream only.)  Inserts anObject as the next
 element that the receiver can access for writing.  Returns anObject."

Stream subclassResponsibility: #nextPut
%

category: 'Adding'
method: Stream
nextPutAllBytes: aCharacterCollection

"(Subclass responsibility, WriteStream only.)  Inserts the byte contents of
 aCharacterCollection as the next elements that the receiver can
 access.  Returns aCharacterCollection."

Stream subclassResponsibility: #nextPutAllBytes:
%

category: 'Adding'
method: Stream
nextPutAll: aCollection

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection.  (WriteStream only.)"

aCollection do: [:each | self nextPut: each].
^ aCollection
%

category: 'Adding'
method: Stream
cr

"Adds a newline to the output stream."

self nextPut: Character lf.
%

category: 'Adding'
method: Stream
lf

"Adds a newline to the output stream."

self nextPut: Character lf.
%

category: 'Adding'
method: Stream
space

"Adds a space to the output stream."

self nextPut: Character space.
%

category: 'Adding'
method: Stream
tab

"Adds a tab to the output stream."

self nextPut: Character tab
%

category: 'Testing'
method: Stream
isExternal

"Returns true if the source of the receiver's information is external to the
 image, and false otherwise."

^false
%

