#set verbose
#=========================================================================
# Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
#
# Name - gemsetup.csh
#
# Purpose - This is a /bin/csh "source" file that explicitly defines your 
#           GemStone environment.
#
#	    a) It adds $GEMSTONE/bin to the end of your PATH.  This is "safe"
#	       in the sense that it will avoids breaking existing user commands
#	       and applications.  It is "unsafe" in the sense that an existing
#	       user command may silently supersede a GemStone-defined command,
#	       such as "topazl".
#
#           b) It adds $GEMSTONE/doc to the end of your MANPATH.  This will
#	       not work with Ultrix and DG/UX man commands, which are not
#	       POSIX compliant.
#
# Note that this script requires that a GEMSTONE environment variable is set
# to a valid GemStone directory.
#
# $Id: gemsetup.csh,v 1.4 2008-01-09 22:50:52 stever Exp $
#
#=========================================================================

set gemsetup_ok = 1

# maintenance symbols
set GEMSTONE_VERSION = 10

if ( $gemsetup_ok ) then
  # Make this check so that -d doesn't crash
  if ( x$GEMSTONE == x ) then
    echo "gemsetup"'['"Error"']'":    GEMSTONE definition is empty"
    set gemsetup_ok = 0
  endif
endif

if ( $gemsetup_ok ) then
  if ( ! -d $GEMSTONE ) then
    echo "gemsetup"'['"Error"']'":    directory GEMSTONE does not exist"
    echo "    GEMSTONE=$GEMSTONE"
    set gemsetup_ok = 0
  endif
endif

# export, just in case user forgot...
if ( $gemsetup_ok ) then
  setenv GEMSTONE $GEMSTONE
endif

# Set path, manpath, etc.
if ( $gemsetup_ok ) then
  set gs_savepath = ( $path )
  set path = ( $path $GEMSTONE/bin )
  rehash
  set defaultManPath = /usr/man
  switch (`uname -s`)
    case AIX: # IBM RIOS/AIX 
      set defaultManPath = /usr/share/man
      breaksw
    case HP-UX: # HP Snake
      # peculiar defaults...
      set defaultManPath = /usr/man:/usr/contrib/man:/usr/local/man
      breaksw
    default:
      # do nothing special...
      set defaultManPath = /usr/man
      breaksw
  endsw
  if ( $?MANPATH == 0 ) then
    setenv MANPATH ${defaultManPath}:$GEMSTONE/doc
  else
    setenv MANPATH ${MANPATH}:$GEMSTONE/doc
  endif
  unset defaultManPath
else
  echo "gemsetup"'['"Warning"']'":  GemStone $GEMSTONE_VERSION setup aborted."
  set gemsetup_ok = 1
endif

unset gemsetup_ok
