/*========================================================================
 * Written by D. Jason Penney, 1991.  Rights to this program are as follows:
 * you may not receive any compensation for distribution of this program
 * except for an optional fee for the distribution medium.  This program
 * must be accompanied by this source code.  This notice may not be removed.
 * Modifications to this program must be clearly noted and marked as such.
 * Since this program is provided free of charge, there is ABSOLUTELY NO
 * WARRANTY.
 *
 * Name - gethostbyname.c
 *
 * Description - 
 *
 * Compile with:
 *   cc -o gethostbyname gethostbyname.c
 *   chmod 555 gethostbyname
 *
 * $Id: gethostbyname.c 26500 2011-08-23 10:34:22Z normg $
 *
 *========================================================================
 */

#if defined(__hpux)
#if !defined(_HPUX_SOURCE)
#define _HPUX_SOURCE
#endif /* !defined(_HPUX_SOURCE) */
#include <sys/stdsyms.h> /* Pick up the other related #defs */

extern int h_errno;
#endif

#if defined(sun) || defined(__sun) || defined(_sun_) || defined(__solaris__)
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>
#include <netdb.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#if defined(MSDOS) || defined(_WIN32)
#include <winsock.h>
#include <io.h>
#elif defined(macintosh) || defined(__MWERKS__)
#include "tnetmac.hf"
#else
#include <netdb.h>
#endif
#if defined(__OS2__)
#include <utils.h>
#endif
#include <ctype.h>
#include <errno.h>

#if defined(__OS2__) || defined(MSDOS) || defined(_WIN32)
  /* declaration OK */
#elif defined(macintosh) || defined(__MWERKS__) || defined(x86_64Linux) || defined(__APPLE_CC__) || defined(__APPLE_CPP__)
  /* declared in tnetmac.hf */
#elif defined(sun) || defined(__sun) || defined(_sun_) || defined(__solaris__)

#else
extern struct hostent *gethostbyname();
#endif

#if defined(MSDOS) || defined(_WIN32)
#define MAKEWORD(a, b)      ((WORD)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))

static void ShutdownNetwork(void)
{
  WSACleanup();
}

static void InitNetwork(void)
{
  WSADATA wsaData;
  WORD version = MAKEWORD(1,1);
  int err = WSAStartup(version, &wsaData);
  if( err == 0 )
    if( LOBYTE(wsaData.wVersion) != LOBYTE(version) ||
       HIBYTE(wsaData.wVersion) != HIBYTE(version) )
      {
        err = WSAVERNOTSUPPORTED;
        fprintf(stderr,
                "The lowest version supported by the DLL is = %d.%d\n",
                LOBYTE(wsaData.wVersion),
                HIBYTE(wsaData.wVersion) );
        fprintf(stderr,
                "The higest version supported by the DLL is = %d.%d\n",
                LOBYTE(wsaData.wHighVersion),
                HIBYTE(wsaData.wHighVersion) );
        WSACleanup();
        exit(1);
      }
  if( err != 0 )
    {
      switch(err)
        {  
        case WSASYSNOTREADY:
          fprintf(stderr, "Windows Socket subsystem not ready.\n");
          break;
        case WSAVERNOTSUPPORTED:
          fprintf(stderr, "Windows Socket API version %d.%d not supported\n",
                  LOBYTE(version), HIBYTE(version) );
          break;
        case WSAEINVAL:
          fprintf(stderr, "Windows Socket version %d.%d not supported\n",
                  LOBYTE(version), HIBYTE(version) );
          break;
        default:
          fprintf(stderr, "Could not find winsock.dll. error=%d\n", err);
          break;
        }   
      exit(1);
    }  
  atexit(ShutdownNetwork);
  return;
}
#endif /* MSDOS */

int main(int argc, char *argv[])
{
struct hostent *thisOne;
char **thisAlias;
char s[BUFSIZ];

#if defined(MSDOS)
char *p;
 
/* When program terminates provide dialog box with program
   exit code and window exit choices. */
_wsetexit(_WINEXITPROMPT);
 
printf("Host name: ");
fflush(stdout);
if (fgets(s, sizeof(s), stdin) == NULL)
   exit(1);
if ( (p = strchr(s, '\n')) != NULL)
  *p = '\0';
 
InitNetwork();
#elif defined(macintosh) || defined(__MWERKS__)
char *p;

printf("Host name: ");
fflush(stdout);
if (fgets(s, sizeof(s), stdin) == NULL)
   exit(1);
if ( (p = strchr(s, '\n')) != NULL)
  *p = '\0';
#else
if (argc != 2) {
  printf("Usage: %s <host-name>\n", argv[0]);
#if defined(VMS)
  exit(EXIT_FAILURE);
#else
  exit(1);
#endif
  }
strncpy(s, argv[1], sizeof(s));
#endif /* MSDOS */

#if defined(MSDOS) || defined(_WIN32)
InitNetwork();
#elif defined(macintosh) || defined(__MWERKS__)
TnetInitMacTCP();
#endif

#if defined(VMS) || defined(MSDOS) || defined(__OS2__) || defined(macintosh) || defined(__MWERKS__) || defined(_WIN32)
thisOne = gethostbyname(s);
#elif defined(__hpux) || defined(sparcSolaris) || defined(_SEQUENT_) \
  || (defined(_nst) && defined(_ATT4) && defined(i386)) || defined(sinix) \
  || defined(AIX) || defined(_AIX) || defined(linux) || defined(__APPLE_CC__) || defined(__APPLE_CPP__)
thisOne = gethostbyname(s);
#elif defined(sun) || defined(__sun) || defined(_sun_) || defined(__solaris__)
thisOne = gethostbyname(s);
#else
thisOne = gethostbyname(s, NULL);
#endif
if (thisOne == NULL) {
#if defined(macintosh) || defined(__MWERKS__)
  fprintf(stderr,
      "%s:  (no entry, errno = %d\n", s, errno);
#else
  fprintf(stderr,
      "%s:  (no entry, errno = %d, h_errno = %d)\n", s, errno, h_errno);
#endif

#if defined(macintosh) || defined(__MWERKS__)
  TnetShutdownMacTCP();
#endif
  return 1;
  }
printf("h_name=%s h_addrtype = %d h_addr = %d.%d.%d.%d\n",
    thisOne->h_name, thisOne->h_addrtype,
    (unsigned char)thisOne->h_addr[0], (unsigned char)thisOne->h_addr[1],
    (unsigned char)thisOne->h_addr[2], (unsigned char)thisOne->h_addr[3]);
#if defined(h_addr)
{ /* new style address list */
  int i;
  unsigned long *current;

  for (i = 1;; i ++) {
    current = (unsigned long *)thisOne->h_addr_list[i];
    if (current == NULL)
      break;
    printf("    %d.%d.%d.%d\n",
	(unsigned char)thisOne->h_addr[0], (unsigned char)thisOne->h_addr[1],
	(unsigned char)thisOne->h_addr[2], (unsigned char)thisOne->h_addr[3]);
    }
}
#endif

if (*thisOne->h_aliases != NULL) {
  printf("aliases: ");
  for (thisAlias = thisOne->h_aliases; *thisAlias != NULL; thisAlias ++)
    printf("%s ", *thisAlias);
  printf("\n");
  }
#if defined(macintosh) || defined(__MWERKS__)
TnetShutdownMacTCP();
#endif
#if defined(VMS)
exit(EXIT_SUCCESS);
#else
return 0;
#endif
}

#if defined(__MWERKS__)
/* incestuous relationship between tnetmac and hostmac */
int HostGetEnv(const char inStr[], char outStr[], unsigned int outSize)
{
  return FALSE;
}
#endif
