!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: associa.gs,v 1.6 2008-01-09 22:50:08 stever Exp $
!
! Superclass Hierarchy:
!   Association, Object.
!
!=========================================================================

removeallmethods Association
removeallclassmethods Association

category: 'For Documentation Installation only'
classmethod: Association
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'An Association is a pair of associated objects: a key and a value.  A
 Dictionary is a collection of Associations; thus, much of the protocol that
 affects Associations is actually defined for instances of Dictionary.  See the
 description of Dictionary for details.'.
doc documentClassWith: txt.

txt := (GsDocText new) details:
'An object, usually used as a reference to its value.'.
doc documentInstVar: #key with: txt.

txt := (GsDocText new) details:
'Another object, referenced by its key.'.
doc documentInstVar: #value with: txt.

self description: doc.
%

category: 'Instance Creation'
classmethod: Association
newWithKey: aKey value: aValue

"Returns a new Association with the argument aKey as its key and with aValue as
 its value."

^ super new key: aKey value: aValue
%

category: 'Accessing'
method: Association
key

"Returns the value of the receiver's key."

^key
%

category: 'Accessing'
method: Association
value

"Returns the value portion of the receiver."

^value
%

category: 'Updating'
method: Association
key: aKey

"Sets the object aKey as the key of the receiver."

key := aKey
%

category: 'Updating'
method: Association
key: aKey value: aValue

"Sets the object aKey as the key of the receiver, and the object aValue as the
 value of the receiver."

key := aKey.
value := aValue
%

category: 'Updating'
method: Association
value: aValue

"Sets the object aValue as the value of the receiver."

value := aValue
%

category: 'Clustering'
method: Association
clusterDepthFirst

"This method clusters the receiver, its key, and its value in
 depth-first order.  It returns true if the receiver has already
 been clustered during the current transaction, false otherwise."

  self cluster
  ifTrue:
    [ ^ true ]
  ifFalse:
    [ key clusterDepthFirst.
      value clusterDepthFirst.
      ^ false
    ].
%

category: 'Comparing'
method: Association
= anObject

"Returns true if (a) the receiver and anObject are of the same class, 
 (b) the receiver and anObject have equal keys and (c) the receiver and
 anObject have the same value.  Returns false otherwise."

"Note: In GemStone 4.1, this method returned true whenever the key of
 the receiver was equal to the key of the argument."

(self == anObject) ifTrue: [^ true].
(self class == anObject class) ifFalse:[^ false].
^ (key = anObject key) _and: [value = anObject value].
%

category: 'Comparing'
method: Association
~= anObject

"Returns true if one or more of the conditions specified in #= method are
 not satisfied.  Returns false otherwise."

"Note: In GemStone 4.1, this method returned true whenever the keys of
 the receiver and the argument were not equal."

^ (self = anObject) not.
%

category: 'Comparing'
method: Association
< anObject

"Returns true if the key of the receiver collates before anObject.
 Returns false otherwise."

^ key == self
  ifTrue: [ false ]
  ifFalse: [ anObject > self key ]
%

category: 'Comparing'
method: Association
<= anObject

"Returns true if the key of the receiver collates before anObject, or if the
 key of the receiver is equivalent to anObject.  Returns false otherwise."

^ key == self
  ifTrue: [ true ]
  ifFalse: [ anObject >= self key ]
%

category: 'Comparing'
method: Association
> anObject

"Returns true if the key of the receiver collates after anObject.
 Returns false otherwise."

^ anObject < self key
%

category: 'Comparing'
method: Association
>= anObject

"Returns true if the key of the receiver collates after anObject, or if the
 key of the receiver is equivalent to anObject.  Returns false otherwise."

^ anObject <= self key
%

category: 'Comparing'
method: Association
hash

"Returns an Integer hash code for the receiver."

^ key hash
%

category: 'Formatting'
method: Association
printOn: aStream

"Puts a displayable representation of the receiver on the given
stream. If the key or the value is identical to the receiver then
avoid an infinite recursion. (There is currently no general way to
limit these kinds of recursions. See Bug #16259)"

key == self
    ifTrue: [aStream nextPutAll: 'anAssociation']
    ifFalse: [key printOn: aStream].
aStream nextPutAll: '->' .
value == self
    ifTrue: [aStream nextPutAll: 'anAssociation']
    ifFalse: [value printOn: aStream]
%
