!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: identityquery.gs,v 1.5 2008-01-09 22:50:11 stever Exp $
!
! Superclass Hierarchy:
!   IdentityIndexQueryEvaluator, IndexedQueryEvaluator, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods IdentityIndexQueryEvaluator
removeallclassmethods IdentityIndexQueryEvaluator

category: 'For Documentation Installation only'
classmethod: IdentityIndexQueryEvaluator
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'IdentityIndexQueryEvaluator is a concrete class that implements the behavior used to 
 evaluate queries against UnordedCollections that have identity indexes. This class is
 used in the internal implementation of indexing and should not be modified.'.
doc documentClassWith: txt.

self description: doc.
%
! ------------------- Class methods for IdentityIndexQueryEvaluator
! ------------------- Instance methods for IdentityIndexQueryEvaluator
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesEqualTo: aValue

"Identity indexes do not support equality comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesGreaterThan: val1
andEquals: bool1
andLessThan: val2
andEquals: bool2

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesGreaterThanKey: aValue andEquals: aBoolean

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesIdenticalTo: aValue

"Returns a set of all values that satisfy the query."

| tmpHolder startPt |

" optimize query for objects in the NSC itself "
self index isIndexOnRootNsc
    ifTrue: [ ^ self _allIdenticalTo: aValue in: self nscRoot ].

tmpHolder := NscBuilder for: self nscRoot speciesForSelect new max: self sizeForNscBuilder.

startPt := self index lastPathComponentsDictionaryOffset.
self index _addAllFor: aValue
    into: tmpHolder
    offset: startPt
    pathTerm: (self index at: startPt).

^ tmpHolder completeBag
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesLessThanKey: aValue andEquals: aBoolean

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesNotEqualTo: aValue

"Identity indexes do not support equality comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueEqualTo: aValue

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueGreaterThan: val1
andEquals: bool1
andLessThan: val2
andEquals: bool2

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueGreaterThanKey: aValue
andEquals: aBoolean

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueIdenticalTo: aValue

"Returns the first value that satisfies the query."

" optimize query for objects in the NSC itself "
self index isIndexOnRootNsc
    ifTrue: [
        (self nscRoot includesIdentical: aValue)
            ifTrue: [ ^ aValue ]
            ifFalse: [ ^ #_incompletePathTraversal ]
    ].

^ self _findFirstValueForKey: aValue
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueLessThanKey: aValue
andEquals: aBoolean

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueNotEqualTo: aValue

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Searching'
method: IdentityIndexQueryEvaluator
_findFirstKeyNotIdenticalTo: aKey atTerm: pathTerm

"Find the first entry with the given path term whose key is not identical to
 the given key and returns the entry's key."

^ self index indexDictionary _findFirstKeyNotIdenticalTo: aKey atTerm: pathTerm
%
