!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: rcbtreeinterior.gs,v 1.5 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   RcBtreeInteriorNode, BtreeInteriorNode, BtreeNode, Array, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods RcBtreeInteriorNode
removeallclassmethods RcBtreeInteriorNode

category: 'For Documentation Installation only'
classmethod: RcBtreeInteriorNode
installDocumentation

| doc txt |
doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
'A RcBtreeInteriorNode represents an interior node of a B-tree for which a
 binary search can be done for a key. Updates to instances of this class are 
 logged and can  be replayed in the case of commit conflicts.' .
doc documentClassWith: txt.

self description: doc.
%

! ------------------- Class methods for RcBtreeInteriorNode
! ------------------- Instance methods for RcBtreeInteriorNode
category: 'Updating'
method: RcBtreeInteriorNode
at: aKey put: aValue

self shouldNotImplement: #at:put:
%
category: 'Updating'
method: RcBtreeInteriorNode
btreeAt: aKey put: aValue

""

self shouldNotImplement: #btreeAt:put:
%
category: 'Updating'
method: RcBtreeInteriorNode
btreeAt: aKey put: aValue for: anIndexObj logging: aBoolean

| res |
res := self _at: aKey put: aValue for: anIndexObj logging: aBoolean.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
category: 'Constants'
method: RcBtreeInteriorNode
parentNodeClass

"Returns the class of node to be created as the parent when a split occurs."

^ RcBtreeInteriorNode
%
category: 'Removing'
method: RcBtreeInteriorNode
removeKey: aKey value: aValue

self shouldNotImplement: #removeKey:value:
%
category: 'Removing'
method: RcBtreeInteriorNode
removeKey: aKey value: aValue for: anIndexObj logging: aBoolean

| res |
res := self _removeKey: aKey value: aValue for: anIndexObj logging: aBoolean.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
