!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: smallin.gs,v 1.16.2.1 2008-03-14 18:25:14 bretlb Exp $
!
! Superclass Hierarchy:
!   SmallInteger, Integer, Number, Magnitude, Object.
!
!=========================================================================

removeallmethods SmallInteger
removeallclassmethods SmallInteger

category: 'For Documentation Installation only'
classmethod: SmallInteger
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'Instances of SmallInteger are an optimization for commonly occurring integers
 (between (2 to the 29 power) and (2 to the 29 power  1)).  You may not
 create subclasses of class SmallInteger.  You may not create any new
 SmallIntegers.  Note that all instances of a given SmallInteger refer to a
 single, unique GemStone object.  That is, they are all both equal (=) and
 identical (==).'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Converting'
method: SmallInteger
_coerce: aNumber

"Reimplemented from Integer."

^aNumber truncated
%

category: 'Converting'
method: SmallInteger
_digitsAsString

"Returns self as a String of at least two digits."

| aString |

(self < 10)
  ifTrue: [aString := '0' , self asString]
  ifFalse: [aString := self asString].
^ aString
%

category: 'Converting'
method: SmallInteger
_digitsAsString3

"Returns self as a String of at least three digits."

self < 100 ifTrue:[
  (self < 10) ifTrue: [
    ^ '00' , self asString
  ] ifFalse:[ 
    ^ '0', self asString 
  ].
] ifFalse:[
  ^ self asString
] 
%

category: 'Converting'
method: SmallInteger
asString

"Returns a String that indicates the numeric value of the
 receiver.  Positive values do not include a leading + ."

<primitive: 54>
self _primitiveFailed: #asString .
self _uncontinuableError
%

category: 'Converting'
method: SmallInteger
asFloat

"Returns a SmallDouble or Float representing the receiver."

<primitive: 138>

self _primitiveFailed: #asFloat .
self _uncontinuableError
%

category: 'Converting'
method: SmallInteger
asDecimalFloat

"Returns a DecimalFloat representing the receiver."

<primitive: 123>

self _primitiveFailed: #asDecimalFloat .
self _uncontinuableError
%

category: 'Converting'
method: SmallInteger
_generality

"Returns the generality of a SmallInteger"

^20
%

category: 'Clustering'
method: SmallInteger
clusterDepthFirst

"Returns true.  (Because SmallIntegers are self-defining objects,
 this method has no effect.)"

^ true
%

category: 'Comparing'
method: SmallInteger
< aNumber

"(Optimized selector.)  Returns true if the receiver is less than aNumber;
 returns false otherwise.

 Do not redefine or override this method in this class."

<primitive: 3>
^ super < aNumber
%

category: 'Comparing'
method: SmallInteger
> aNumber

"(Optimized selector.)  Returns true if the receiver is greater than aNumber;
 returns false otherwise.

 Do not redefine or override this method in this class."

<primitive: 4>
^ super > aNumber
%

category: 'Comparing'
method: SmallInteger
<= aNumber

"(Optimized selector.)  Returns true if the receiver is less than or equal to
 aNumber; returns false otherwise.

 Do not redefine or override this method in this class."

<primitive: 5>
^ super <= aNumber
%

! = is an optimized selector and must not have an implementation here.

! hash is now inherited from Integer

category: 'Comparing'
method: SmallInteger
identityHash

"Returns a numeric hash index.  For a SmallInteger, returns the receiver."

^self
%

! >= is an optimized selector and must not have an implementation here.

category: 'Comparing'
method: SmallInteger
~= aNumber

"(Optimized selector.)  Returns true if the receiver is not equal to aNumber;
 returns false otherwise.

 Do not redefine or override this method in this class."

<primitive: 8>
^ super ~= aNumber
%

category: 'Copying'
method: SmallInteger
copy

"Overrides the inherited method; you cannot create any new SmallIntegers.
 Returns the receiver."

^ self
%

! the selectors #+, #-, #*, #>= are optimized selectors and must not have 
!  implementations here.  perform of these selectors is handled by
!  the implementations in Integer .

! fix bug 8400 by testing for self == 0 before creating a fraction 
category: 'Arithmetic'
method: SmallInteger
/ aNumber

"Returns the result of dividing the receiver by aNumber."

<primitive: 10>
(aNumber = 0) ifTrue: [^ self _errorDivideByZero].
(aNumber _isInteger)
  ifTrue:[ ^ Fraction numerator: self denominator: aNumber ]
  ifFalse: [ ^ super / aNumber]
%

category: 'Arithmetic'
method: SmallInteger
// aNumber

"Divides the receiver by aNumber.
 Returns the integer quotient, with truncation toward negative infinity.
 For example,

 9//4 = 2
 -9//4 = -3

 The selector \\ returns the remainder from this division."

<primitive: 12>
(aNumber = 0)
  ifTrue: [^ self _errorDivideByZero]
  ifFalse: [^ super // aNumber]
%

category: 'Arithmetic'
method: SmallInteger
quo: aNumber

"Divides the receiver by aNumber.  Returns the integer quotient, with
 truncation toward zero.  For example,

 -9 quo: 4 = -2

 The selector rem: returns the remainder from this division."

<primitive: 13>
(aNumber = 0)
  ifTrue: [^ self _errorDivideByZero]
  ifFalse: [^ super quo: aNumber]
%

category: 'Arithmetic'
method: SmallInteger
\\ aNumber

"Returns the modulus defined in terms of //.  Returns a Number with the same
 sign as the argument aNumber.  For example,

 9\\4 = 1
 -9\\4 = 3
 9\\-4 = -3"

<primitive: 11>
(aNumber = 0)
  ifTrue: [^ self _errorDivideByZero]
  ifFalse: [^ super \\ aNumber]
%

category: 'Bit Manipulation'
method: SmallInteger
bitAnd: aNumber

"Returns an Integer whose bits are the logical and of the receiver's bits and
 the bits of aNumber."

<primitive: 14>
^aNumber bitAnd: self
%

category: 'Bit Manipulation'
method: SmallInteger
bitOr: aNumber

"Returns an Integer whose bits are the logical or of the receiver's bits and
 the bits of aNumber."

<primitive: 15>
^aNumber bitOr: self
%

! fixed 33631
category: 'Bit Manipulation'
method: SmallInteger
bitShift: shift

"Returns an Integer whose value (in two's-complement representation) is the
 receiver's value (also in two's-complement representation) shifted left by
 'shift' bits.

 Negative arguments shift right.  Zeros are shifted in from the right in left
 shifts.  The sign bit is extended in right shifts."

<primitive: 17>
shift _validateClass: SmallInteger.
^ super bitShift: shift
%

category: 'Bit Manipulation'
method: SmallInteger
bitXor: aNumber

"Returns an Integer whose bits are the logical xor of the receiver's bits and
 the bits of aNumber."

<primitive: 16>
^aNumber bitXor: self
%


! fixed 36141
category: 'Bit Manipulation'
method: SmallInteger
highBit

"Returns the index of the high-order bit that is set in the binary
 representation of the receiver.  (If the receiver is negative, takes its
 absolute value first.)  If the receiver is zero, this returns nil."

| aValue index |

(self == 0) "It is misleading to return 0 when the receiver is 0."
   ifTrue: [^ nil].
aValue := self abs.  "Returns the highest set bit of the absolute value."

index := 0.
"right shift until = 1"
[ aValue ~~ 1 ] whileTrue: [
  index := index + 1.
  aValue := aValue bitShift: -1
].
^ index
%

category: 'Bit Manipulation'
method: SmallInteger
asBitString

"Returns a string of 1 and 0 Characters representing the bits in the receiver."

| bit num bits str |

bits := #[].
bit := 1.
num := self.
[
  bits add: (num bitAnd: bit).
  num := num bitAnd: bit bitInvert.
  bit := bit bitShift: 1.
  num == 0
] untilTrue.

str := String new.
bits size downTo: 1 do:
  [ :i | str add: ((bits at: i) > 0 ifTrue: [$1] ifFalse: [$0]) ].

^str.
%

category: 'Formatting'
method: SmallInteger
printString

"Returns a String whose contents are a displayable representation of the
 receiver."

"Reimplemented for efficiency.  GemStone does not allow the creation of new
 kinds of Number, so there is no point in creating a stream and sending
 printOn:"

^self asString
%

category: 'Queries'
classmethod: SmallInteger
maximumValue

"Returns the maximum allowable SmallInteger value."

^ 1152921504606846975
%

category: 'Queries'
classmethod: SmallInteger
minimumValue

"Returns the minimum allowable SmallInteger value."

^ -1152921504606846976
%

category: 'Storing and Loading'
method: SmallInteger
containsIdentity

"Private."

^true
%
category: 'Testing'
method: SmallInteger
isSpecial

"Returns true if the receiver is a special object."

^ true
%
category: 'Private'
method: SmallInteger
_floatParts

" Returns a 2 element Array describing receiver;
    first element is a Float , 
    second element is an Integer .
  The Float represents the most significant 53 bits
  of the receiver, rounded the same as  for Integer>>asFloat .
  The second element is the power of 2 describing the
  remaining bits of the receiver."

^ #[ self asFloat , 0 ]
%

category: 'Arithmetic'
method: SmallInteger
raisedTo: aNumber

"Returns the receiver raised to the power of the argument."
<primitive: 662>
"primitive handles integer and binary float args"
"overflow of result to LargeInteger comes here"

^ super raisedTo: aNumber  
%

category: 'Arithmetic'
method: SmallInteger
raisedToInteger: aNumber

(aNumber isKindOf:Integer) ifFalse:[
  aNumber _validateClass: Integer
].
^ self raisedTo: aNumber
%
