!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: symbols.gs,v 1.4 2008-01-09 22:50:19 stever Exp $
!
! Superclass Hierarchy:
!   SymbolSet, IdentitySet, IdentityBag, UnorderedCollection, Collection,
!   Object.
!
!=========================================================================

removeallmethods SymbolSet
removeallclassmethods SymbolSet

category: 'For Documentation Installation only'
classmethod: SymbolSet
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A SymbolSet is an IdentitySet whose elements must be canonical symbols
 (Symbols or DoubleByteSymbols).' .
doc documentClassWith: txt.

self description: doc.
%

! remove: inherited from IdentitySet
! remove: aSymbol ifAbsent: aBlock  inherited from IdentitySet

category: 'Accessing'
method: SymbolSet
_returnValueOf: anObject

"Returns the element of the receiver whose value is the same as the argument.
 If the argument is not equal to any value in the receiver, then add the
 argument to the receiver."

|symbolizedObject|

symbolizedObject := anObject asSymbol.
self add: symbolizedObject.
^ symbolizedObject
%

! add: inherited from IdentitySet
! addAll:  inherited from IdentitySet

category: 'Adding'
method: SymbolSet
_addSymbol: aSymbol

"Obsolete, provided for compatibility.
 Same functionality as IdentitySet | add: "

^ self add: aSymbol
%

category: 'Repository Conversion'
method: SymbolSet
rehashForConversion

"This is a new class in 5.0. Return the receiver."

^ self.
%

