!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: writest.gs,v 1.6 2008-01-09 22:50:20 stever Exp $
!
! Superclass Hierarchy:
!   WriteStream, PositionableStream, Stream, Object.
!
!=========================================================================

removeallmethods WriteStream
removeallclassmethods WriteStream

category: 'For Documentation Installation only'
classmethod: WriteStream
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A WriteStream is a PositionableStream that allows its objects to be written,
 but not read.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Instance Creation'
classmethod: WriteStream
new

"Disallowed.  To create a new WriteStream, use the class method on: instead."

self shouldNotImplement: #new
%

category: 'Accessing'
method: WriteStream
next

"Disallowed.  You cannot read a WriteStream."

self shouldNotImplement: #next
%


category: 'Adding'
method: WriteStream
nextPut: anObject

"Inserts anObject as the next element that the receiver can access for writing.
 Returns anObject."

itsCollection at: position put: anObject.
position := position + 1.
^ anObject
%

category: 'Adding'
method: WriteStream
nextPutAll: aCollection

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection."

position == (itsCollection size + 1)
ifFalse:
  [ ^ super nextPutAll: aCollection ].
itsCollection addAll: aCollection.
position := position + (aCollection size).
^ aCollection
%

category: 'Adding'
method: WriteStream
nextPutAllBytes: aCharacterCollection

"Inserts the byte contents of aCharacterCollection as the next elements 
 that the receiver can access.  Returns aCollection.  The receiver's collection
 must be a GsFile or a String."

"Used in the implementation of PassiveObject."

position == (itsCollection size + 1)
ifFalse:
  [ ^ super nextPutAllBytes: aCharacterCollection ].
itsCollection addAllBytes: aCharacterCollection.
position := position + (aCharacterCollection _basicSize).
^ aCharacterCollection
%

category: 'Accessing'
method: WriteStream
contents

"WriteStreams return the portion of their collection that has been written:
 the collection up to the next write-position."

position < 2 ifTrue: [ ^itsCollection species new ].
^itsCollection copyFrom: 1 to: position-1
%

category: 'ANSI'
method: WriteStream
flush
	"Update a stream's backing store.
	Upon return, if the receiver is a write-back stream, the state of the
	stream backing store must be consistent with the current state of the 
	receiver.
	If the receiver is not a write-back stream, the effect of this 
	message is unspecified."

	"We do nothing; this method is provided for ANSI compatibility"
%
