#set -x
#=========================================================================
# Copyright (C) VMware, Inc. 1986-2012.  All Rights Reserved.
#
# Name - misc.sh
#
# Purpose - set up various useful functions and defaults for scripts
#
# $Id: misc.solarisx86.sh 19139 2008-05-30 23:48:14Z stever $
#
#=========================================================================

EXEEXT=
if [ -d /opt/gemstone ]; then
  GEMSTONE_LOCKBASE=/opt/gemstone
elif [ -d /usr/gemstone ]; then
  GEMSTONE_LOCKBASE=/usr/gemstone
else
  GEMSTONE_LOCKBASE=/opt/gemstone
fi
GEMSTONE_LOCKEXT="..LCK"                 # lock dir file extention
GEMSTONE_LOCKDIR="$GEMSTONE_LOCKBASE/locks"
NULLDEV=/dev/null
RM=/bin/rm
LS=/bin/ls
GSTMP=/tmp

GEMSTONE_LOGDIR="$GEMSTONE_LOCKBASE/log"          #   required log directory

# first argument is the switch passed, second is message to read from
# language file...

# first argument is the switch passed, second is string to print
giveHelp() {
  # Make sure user has decent pager...
  if [ "x$PAGER" = "x" ]; then
    PAGER=more
  fi
  # Preferred help command is "-h."  Support "-H" and "help" for compatibility.
  if [ "x$1" = "x-h" ] || [ "x$1" = "x-H" ] || [ "x$1" = "xhelp" ]; then
    echo "Usage: $2 "
    exit 0
  fi
}


# error control
defaultErrorControl() {
  trap 'echo "${comid}[Error]:   ^C termination."; exit 1' 2	# SIGINT
  trap 'echo "${comid}[Error]:   kill termination."; exit 1' 15	# SIGTERM
  trap '' 1 					# SIGHUP
}

# switch procesing
# echo "in misc.sh SCRIPTDIR = $SCRIPTDIR" # enable for debugging
getSwitches() {
  #  echo "in getSwitches SCRIPTDIR = $SCRIPTDIR"  # enable for debugging
  unset _POSIX_OPTION_ORDER # Disable queer getopt mode
  switches="`$GEMSTONE/bin/ggetopt $1 $2`"
  status=$?
  if [ $status -ne 0 ]; then
    # ggetopt error
    echo "${comid}[Error]:   ggetopt error"
    exit 1
  fi
}

# Put descriptor limit back!
returnDescriptors() {
  if [ $hasDescCmd = y ]; then
    ulimit -n $originalDescriptorLimit
  fi
}

requireDirs() {
  for directory in $*
  do
    if [ ! -d $directory ]; then
      echo "${comid}[Error]:   required directory $directory is missing."
      exit 1
    fi
  done
}

requireExes() {
  for file in $*
  do
    if [ ! -x $file$EXEEXT ]; then
      echo "${comid}[Error]:   cannot execute file $file$EXEEXT "
      exit 1
    fi
  done
}

simpleNRS () {
  # we must have a name - i.e. !tcp!name
  if [ "x$nrbody" = "x" ]; then
    # no name given
    echo "${comid}[Error]:       can not determine name part of the gemStoneName NRSpec."
    exit 1
  fi 

  # name must not include spaces or tabs
  spaceindex=`expr "$nrbody" : '.* .*'`
  tabindex=`expr "$nrbody" : '.*	.*'`
  if [ $spaceindex -ne 0 ] || [ $tabindex -ne 0 ]; then
    echo "${comid}[Error]: name part of netLdiName $nrbody has white space."
    exit 1
  fi

  # name must NOT be a filespec or path 
  stoneName_first_char=`expr "$nrbody" : '^\(.\).*$'`
  if [ "x$stoneName_first_char" = "x/" ]; then
    echo "${comid}[Error]:    name part of gemStoneName $nrbody must not be a path."
    exit 1 
  fi

  # the task type must be "" or "server"
  if [ "$nrexplicit" = "y" ] && [ "x$nrtaskname" != "x" ]; then
    if [ "$nrtaskname" != "server" ]; then
      echo "${comid}[Error]:    $nrtaskname , invalid gemStoneName NRSpec modifier."
      exit 1 
    fi
  fi

  # tcp or TCP protocol only! for now
  if [ "x$nrprotocol" = "x" ]; then nrprotocol="$default_protocol"; fi
  if [ "$nrprotocol" != "tcp" ] && [ "$nrprotocol" != "TCP" ]; then
    echo "${comid}[Error]:    $nrprotocol network protocol is not recognized."
    exit 1
  fi
}

# initialize arguments used for setconfig...
initConfig() {
  systemConfig=""
  exeConfig="$1"
  netLdiSpec=""
  runpgsvrSpec=""
}

##############################################################################
# Platform specific stuff follows...
# This file is specific for solaris on x86 only!!
##############################################################################

HOSTTYPE=i386
export HOSTTYPE
OSTYPE=Solaris
export OSTYPE
vendor="Sun Microsystems, Inc."
PING=/usr/sbin/ping
pingArgs=""
pingPostArgs=""

# raise file descriptors, i.e., just before calling executable
# saves old descriptor limit in originalDescriptorLimit
raiseDescriptors() {
  hasDescCmd=y
  descriptorLimit=1024
  originalDescriptorLimit=`ulimit -n`
  if [ $originalDescriptorLimit -lt $descriptorLimit ]; then
    ulimit -n $descriptorLimit
  else
    descriptorLimit=$originalDescriptorLimit
  fi
}

getSwapPgm() {
  swapPgm=/etc/swap 
}

getSwapSize() {
  $swapPgm -s > $tmpFile
  theSize="`cat $tmpFile | cut -f11 -d\" \" | cut -f1 -dk `"
}

getTabSize() {
  tabSize=skip
}

getAioRequired() {
  aioRequired=n
}
