!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: SystemLoginNotification.gs,v 1.1 2008-01-09 22:33:41 dhenrich Exp $
!
! Superclass Hierarchy:
!   SystemLoginNotification, Object
!
!=========================================================================

expectvalue %String
doit
| oldCls newCls |
oldCls := Globals at:#SystemLoginNotification otherwise: nil .
oldCls == nil ifTrue:[
Object  _newKernelSubclass: #SystemLoginNotification
  instVarNames: #()
  classVars: #( Subscriptions)
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[]
  instancesInvariant: false
  isModifiable: true
  reservedOop: nil.
(Globals at:#SystemLoginNotification) immediateInvariant.
"move the association for Subscriptions into Segment 0"
((Globals at:#SystemLoginNotification) _classVars associationAt: #Subscriptions) assignToSegment: nil.
newCls := (Globals at:#SystemLoginNotification) .
  ^ 'created new class: ' + newCls definition
 ]
ifFalse:[
  ^ 'existing class: ' + oldCls definition
 ]
%

! Remove existing behavior from SystemLoginNotification
doit
SystemLoginNotification removeAllMethods.
SystemLoginNotification class removeAllMethods.
true
%
! ------------------- Class methods for SystemLoginNotification
category: 'notification'
classmethod: SystemLoginNotification
sessionStart
    "Nothing by default"
%
