!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: magnitu.gs,v 1.5 2008-01-09 22:50:12 stever Exp $
!
! Superclass Hierarchy:
!   Magnitude, Object.
!
!=========================================================================

removeallmethods Magnitude
removeallclassmethods Magnitude

category: 'For Documentation Installation only'
classmethod: Magnitude
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'Magnitude is an abstract superclass that defines methods for kinds of objects
 that are ordered.  Concrete subclasses of Magnitude include Character,
 DateTime, and Integer.'.
doc documentClassWith: txt.

txt := (GsDocText new) details:
'A subclass of Magnitude must implement two comparison operators: equality (=)
 and less-than (<).  The remaining comparison operators are defined in terms
 of these two operations, so the subclass can inherit their definitions.  Each
 of these methods generates an error if the argument aMagnitude cannot be
 compared with the receiver.'.
doc documentCategory: #Comparing with: txt.

self description: doc.
%

category: 'Instance Creation'
classmethod: Magnitude
fromStream: aStream

"(Subclass responsibility.)  Returns an instance of the receiver."

Magnitude subclassResponsibility: #fromStream:
%

category: 'Instance Creation'
classmethod: Magnitude
fromString: aString

"Returns an instance of the appropriate subclass, reconstructed from aString.
 The String must contain only Characters representing the object to be created,
 although leading and trailing blanks are permitted."

| s result |

s := ReadStream on: aString.
result := self fromStream: s.
[ s atEnd ]
whileFalse:
  [ (s next isEquivalent:  $ )
    ifFalse:
      [ self _errIncorrectFormat: aString ]
  ].
^ result
%

category: 'Comparing'
method: Magnitude
< aMagnitude

"(Subclass responsibility.)  Returns true if the receiver is less than
 aMagnitude; returns false otherwise."

Magnitude subclassResponsibility: #<
%

category: 'Comparing'
method: Magnitude
<= aMagnitude

"Returns true if the receiver is less than or equal to aMagnitude;
 returns false otherwise."

^(self > aMagnitude) not
%

category: 'Comparing'
method: Magnitude
> aMagnitude

"Returns true if the receiver is greater than aMagnitude;
 returns false otherwise."

^ aMagnitude < self
%

category: 'Comparing'
method: Magnitude
>= aMagnitude

"Returns true if the receiver is greater than or equal to aMagnitude;
 returns false otherwise."

^(self < aMagnitude) not
%

category: 'Comparing'
method: Magnitude
= aMagnitude

"(Subclass responsibility.)  Returns true if the receiver is equal to
 aMagnitude; returns false otherwise."

Magnitude subclassResponsibility: #=
%

category: 'Comparing'
method: Magnitude
hash

"(Subclass responsibility.)  Returns a numeric hash index."

"Two Numbers for which = is true, must have the same hash value."

Magnitude subclassResponsibility: #hash
%

category: 'Comparing'
method: Magnitude
between: min and: max

"Returns true if the receiver is less than or equal to the argument max and
 greater than or equal to the argument min.  Returns false otherwise."

^ (self >= min) & (self <= max)
%

category: 'Comparing'
method: Magnitude
max: aMagnitude

"Returns the receiver or the argument, whichever has the greater magnitude."

self > aMagnitude
        ifTrue: [^self].
^aMagnitude
%

category: 'Comparing'
method: Magnitude
min: aMagnitude

"Returns the receiver or the argument, whichever has the lesser magnitude."

self < aMagnitude
        ifTrue: [^self].
^aMagnitude
%

category: 'Private'
method: Magnitude
_deepCopyWith: copiedObjDict

"(R) Private. Used internally to implement deepCopy."

| copy |

self isSpecial ifTrue: [ ^ self ].

copy := copiedObjDict at: self otherwise: nil.
copy ~~ nil ifTrue: [ ^ copy ].

copy := self copy.
copiedObjDict at: self put: copy.

^ copy.
%
