!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: processor.gs,v 1.5 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   Processor, Object.
!
!=========================================================================

expectvalue %String
run
Object _newKernelSubclass: #Processor
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[]
  instancesInvariant: false
  isModifiable: false
  reservedOop: 909
%

! Remove existing behavior from Processor
removeallmethods Processor
removeallclassmethods Processor

! ------------------- Class methods for Processor
category: 'Forwarding'
classmethod: Processor
doesNotUnderstand: message
  "forward the message to the current scheduler"
  ^ProcessorScheduler scheduler perform: (message at: 1) withArguments: (message at: 2)
%

category: 'Process State Change'
classmethod: Processor
yield

^ProcessorScheduler scheduler yield
%

category: 'Accessing'
classmethod: Processor
activeProcess

^ProcessorScheduler scheduler activeProcess
%

category: 'Accessing'
classmethod: Processor
activePriority

^ProcessorScheduler scheduler activePriority
%

category: 'Accessing'
classmethod: Processor
allProcesses

^ProcessorScheduler scheduler allProcesses
%

category: 'Accessing'
classmethod: Processor
readyProcesses

^ProcessorScheduler scheduler readyProcesses
%

category: 'Accessing'
classmethod: Processor
waitingProcesses

^ProcessorScheduler scheduler waitingProcesses
%

category: 'Accessing'
classmethod: Processor
suspendedProcesses

^ProcessorScheduler scheduler suspendedProcesses
%

category: 'Priorities'
classmethod: Processor
highestPriority

^ProcessorScheduler scheduler highestPriority
%

category: 'Priorities'
classmethod: Processor
timingPriority

^ProcessorScheduler scheduler timingPriority
%

category: 'Priorities'
classmethod: Processor
highIOPriority

^ProcessorScheduler scheduler highIOPriority
%

category: 'Priorities'
classmethod: Processor
lowIOPriority

^ProcessorScheduler scheduler lowIOPriority
%

category: 'Priorities'
classmethod: Processor
userInterruptPriority

^ProcessorScheduler scheduler userInterruptPriority
%

category: 'Priorities'
classmethod: Processor
userSchedulingPriority

^ProcessorScheduler scheduler userSchedulingPriority
%

category: 'Priorities'
classmethod: Processor
userBackgroundPriority

^ProcessorScheduler scheduler userBackgroundPriority
%

category: 'Priorities'
classmethod: Processor
lowestPriority

^ProcessorScheduler scheduler lowestPriority
%

! ------------------- Instance methods for Processor
