!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: rcbtreeleaf.gs,v 1.4 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   RcBtreeLeafNode, BtreeLeafNode, BtreeNode, Array,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods RcBtreeLeafNode
removeallclassmethods RcBtreeLeafNode

category: 'For Documentation Installation only'
classmethod: RcBtreeLeafNode
installDocumentation

| doc txt |
doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
'A RcBtreeLeafNode represents an exterior node of a B-tree for which a binary
 search can be done for a key. Updates to instances of this class are logged and 
 can  be replayed in the case of commit conflicts.' .
doc documentClassWith: txt.

self description: doc.
%

! ------------------- Class methods for RcBtreeLeafNode
! ------------------- Instance methods for RcBtreeLeafNode
category: 'Updating'
method: RcBtreeLeafNode
at: aKey put: aValue

self shouldNotImplement: #at:put:
%
category: 'Updating'
method: RcBtreeLeafNode
btreeAt: aKey put: aValue

""

self shouldNotImplement: #btreeAt:put:
%
category: 'Updating'
method: RcBtreeLeafNode
btreeAt: aKey put: aValue for: anIndexObj logging: aBoolean

| res |
res := super at: aKey put: aValue.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
res ~~ self
  ifTrue: [
    System redoLog addConflictObject: res for: anIndexObj.
    System _addRootObjectToRcReadSet: res.
  ].
^res
%
category: 'Constants'
method: RcBtreeLeafNode
parentNodeClass

"Returns the class of node to be created as the parent when a split occurs."

^ RcBtreeInteriorNode
%
category: 'Removing'
method: RcBtreeLeafNode
removeKey: aKey value: aValue

self shouldNotImplement: #removeKey:value:
%
category: 'Removing'
method: RcBtreeLeafNode
removeKey: aKey value: aValue for: anIndexObj logging: aBoolean

| res |
res := super removeKey: aKey value: aValue.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
