!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: rcqsession.gs,v 1.5 2008-01-09 22:50:14 stever Exp $
!
! Superclass Hierarchy:
!   RcQueueSessionComponent, Array, SequenceableCollection, Collection, Object.
!
!=========================================================================

expectvalue %String
run
  ^ Array _newKernelSubclass: 'RcQueueSessionComponent'
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: #[]
    inDictionary: Globals
    constraints: #[ "unnamed part" RcQueueElement ]
    instancesInvariant: false
    isModifiable: false
    reservedOop: 853 .
%

removeallmethods RcQueueSessionComponent
removeallclassmethods RcQueueSessionComponent

category: 'For Documentation Installation only'
classmethod: RcQueueSessionComponent
installDocumentation

| doc txt |
doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
'An RcQueueSessionComponent is the unit within a reduced-conflict queue that
 holds all of the queue entries submitted by a given session.  A new RcQueue
 allows the same number of sessions as the GemStone system''s maximum number of
 sessions.  You can modify this number using the changeMaxSessionId: method.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Constants'
classmethod: RcQueueSessionComponent
speciesOfElements

^RcQueueEntry
%

category: 'Copying'
method: RcQueueSessionComponent
copy

|result|
result := super copy.
1 to: self _basicSize do:[:n| result _at: n put: (self _at: n) copy ].
^result
%

