!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!=========================================================================

expectvalue /String
run
( TestResult subclass: 'GSTestResult'
  instVarNames: #()
  classVars: #( )
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals  options: #( #instancesNonPersistent) 
  ) definition
%
expectvalue /String
run
(IdentitySet subclass: 'IdentitySetNP'
  instVarNames: #() classVars: #() classInstVars: #() poolDictionaries: #()
  inDictionary: UserGlobals options: #( #instancesNonPersistent )
) definition
%
run
(Array subclass: 'ArrayNP'
  instVarNames: #() classVars: #() classInstVars: #() poolDictionaries: #()
  inDictionary: UserGlobals options: #( #instancesNonPersistent )
) definition
%

! Remove existing behavior from GSTestResult
doit
GSTestResult removeAllMethods.
GSTestResult class removeAllMethods.
"To satisfy forward refs"
(Globals includesKey: #GSTestCase) ifFalse: [Globals at: #GSTestCase put: nil]
%
! ------------------- Class methods for GSTestResult
! ------------------- Instance methods for GSTestResult
set class GSTestResult

method: GSTestResult
runCase: aTestCase
 | debugBlk |
"uncomment and enable to get an SUnit.log file of send...debug: of all the test cases"
" (SessionTemps current at: #Ernie_collectCases otherwise: nil) ifNotNil:[
   GSTestCase logCr: aTestCase class name , ' debug: ', aTestCase selector printString.
   ^ self
 ]."
" debugBlk := [ :ex |
   (SessionTemps current at: #Ernie_debugIgnoreErrNum otherwise: nil) ifNotNil:[:n |
     ex gsNumber == n ifFalse:[ nil pause ].
   ].
 ]. "
 (self class excludeInSoloSession: aTestCase) ifTrue:[
   GSTestCase logCr: aTestCase printString , ' -  Excluding inROS'.
   ^ self .
 ]. 
 [
   [  aTestCase runCase.
      self passed add: aTestCase.
   ] on: self class failure do: [:ex |
     "debugBlk value: ex . "
     self addFailure: aTestCase.
     GSTestCase logCr: 'fail - ' , ex description asString.
     self
   ].
 ] on: (Error, Notification) do: [:ex | 
   ex class defaultHandlers size > 0 ifTrue:[ ex pass ].
		"debugBlk value: ex  ."
		self addError: aTestCase.
		GSTestCase logCr: 'error - ' , ex description asString .
	  GSTestCase isDebug ifFalse:[
           GSTestCase logCr:'------------------------------(
' , (GsProcess stackReportToLevel:300) , '
------------------------------)'.
   ].
   self
 ].
%

classmethod:
excludeInSoloSession: aTestCase
  "Returns a Boolean, true if aTestCase should be skipped."
  | cls arr |
  GsSession isSolo ifFalse:[ ^ false ].
  cls := aTestCase class .
  arr := SessionTemps current at: #ExcludeInSoloSession otherwise: nil .
  "arr has 2 elements, 
      Array of classes for which all testcase subclasses are excluded,
      IdentityDictionary 
         key a test case class, value an IdentitySet of excluded selectors.
  "      
  arr ifNotNil:[ | dict set |
    (arr at: 1) do:[:aClass | (cls _subclassOf: aClass) ifTrue:[ ^ true ]].
    dict := arr at: 2.
    set := dict at: cls otherwise: nil .
    set ifNotNil:[ 
      (set includes: aTestCase selector) ifTrue:[ ^ true ].
      (set includes: #'*ALL') ifTrue:[ ^ true ].
    ].
  ].
  ^ false .
%
! set class GSTestResult

classmethod: 
loadSoloExclusions: anArray
  | dict allSubArr exclArr line symList |
  dict := IdentityKeyValueDictionary new .
  allSubArr := Array new .
  exclArr := { allSubArr . dict }.
  SessionTemps current at: #ExcludeInSoloSession put: exclArr .
  line := 0 .
  symList := System myUserProfile symbolList .
  1 to: anArray size by: 2 do:[:n | | clsName sel cls |
     line := line + 1.
     clsName :=   anArray at: n .
     sel :=       anArray at: n+1 .

     cls := (symList resolveSymbol: clsName) value .
     sel == #'*ALLSubclasses' ifTrue:[ 
       allSubArr add: cls
     ] ifFalse:[ | set |
       set := dict at: cls ifAbsent:[ dict at: cls put: IdentitySet new ].
       set add: sel .
     ].
  ].
  GsFile gciLogServer:'loaded ' , line asString , ' exclusions'.
%

method: GSTestResult
failures
   failures ifNil: [failures := ArrayNP new ].
   ^failures
%
method: GSTestResult
errors
  "One list in order of occurrance"
  ^ self failures
%
method: GSTestResult
defects
 ^ self failures
%
method: GSTestResult
addError: arg
  "nil pause . ""uncomment to debug test framework"
  super addError: arg
%
method: GSTestResult
addFailure: arg
  "nil pause . ""uncomment to debug test framework"
  super addFailure: arg
%

!--------------------------------------------------
!  The test cases under CoreTestCase 
!  expected to fail in a  Solo session 
!
classmethod: GSTestResult
loadSoloExclusions
(SessionTemps current at: #ExcludeInSoloSession otherwise:nil) ifNil:[
  self loadSoloExclusions:

#(  "line 0"
MultiSessionTests   #'*ALLSubclasses' 
IXQueryCoverageTests #'*ALLSubclasses' 
IXQueryTestCase #'*ALLSubclasses'
IXQueryCoverageGeneratorTests #'*ALLSubclasses'
ArrayTestCase   #test_addAll_9
ArrayTestCase   #test_addLast_
ArrayTestCase   #test_add_8
ArrayTestCase   #test_copyFrom_to_into_startingAt_5
BehaviorTestCase   #testBug40345
BehaviorTestCase   #testBug44352
BehaviorTestCase   #test_48261
BlockClosureTestCase   #test
Bug1104 #'*ALL'
Bug1465 #test
Bug11355   #test
Bug1239   #test
Bug36681   #test
ByteArrayTestCase   test_addAll_
ByteArrayTestCase   test_add_
ByteArrayTestCase   test_at_putAllOldOopsOfObjects_
ByteArrayTestCase   test_at_putAllOopsOfObjects_
ByteArrayTestCase   test_at_putChar_
ByteArrayTestCase   test_at_putOldOopValueOfObject_
ByteArrayTestCase   test_at_putOopValueOfObject_
ByteArrayTestCase   test_at_put_fromOffset_sizeBytes_
ByteArrayTestCase   test_at_put_signed_width_
ByteArrayTestCase   test_copyFrom_to_into_startingAt_1
ByteArrayTestCase   test_dateTime32At_put_
ByteArrayTestCase   test_dateTime32NativeAt_put_
ByteArrayTestCase   test_dateTime64At_put_
ByteArrayTestCase   test_doubleAt_put_
ByteArrayTestCase   test_insertAll_at_
ByteArrayTestCase   test_nextPutAllOldOopsOfObjects_
ByteArrayTestCase   test_nextPutAllOopsOfObjects_
ByteArrayTestCase   test_nextPutOldOopOfObject_
ByteArrayTestCase   test_nextPutOopOfObject_
ByteArrayTestCase   test_removeFrom_to_
ByteArrayTestCase   test_signed16At_put_
ByteArrayTestCase   test_signed24At_put_
ByteArrayTestCase   test_signed32At_put_
ByteArrayTestCase   test_signed64At_put_
ByteArrayTestCase   test_signed8At_put_
ByteArrayTestCase   test_string4gAt_put_fromOffset_
ByteArrayTestCase   test_string64kAt_put_fromOffset_
ByteArrayTestCase   test_stringAt_put_fromOffset_
ByteArrayTestCase   test_unsigned16At_put_
ByteArrayTestCase   test_unsigned24At_put_
ByteArrayTestCase   test_unsigned32At_put_
ByteArrayTestCase   test_unsigned64At_put_
ByteArrayTestCase   test_unsigned8At_put_
CanonicalizationTestCase   #'*ALL' 
CanonStringDictTestCase   test_add_
CanonStringDictTestCase   test_removeKey_ifAbsent_
CharacterCollectionTestCase   test_addAll_
CharacterCollectionTestCase   test_addLast_
CharacterCollectionTestCase   test_addAll_
CharacterCollectionTestCase   test_addLast_
CharacterCollectionTestCase   test_addLineWith_centeredToWidth_
CharacterCollectionTestCase   test_add_
CharacterCollectionTestCase   test_copyFrom_to_into_startingAt_
CharacterCollectionTestCase   test_insertObject_at_
CharacterCollectionTestCase   test_insert_at_1
CharacterCollectionTestCase   test_width_1
ClassOrganizerTestCase   test43197
ClassTestCase   test_clsCreation_IICCPIII_v2
ClassTestCase   test_clsCreation_IICCPIII_v4
ClassTestCase   test_clsCreation_IICCPIINI_v2
ClassTestCase   test_clsCreation_IICCPIINI_v4
ClassTestCase   test_clsCreation_SICCPIII_v2
ClassTestCase   test_clsCreation_SICCPIII_v4
ClassTestCase   test_clsCreation_SICCPIINI_v2
ClusterTestCase   #'*ALL'
ContextTestCase   testConnectedBlock
ContextTestCase   testObjectSecurityPolicyAuthorization
ContinueTransactionTestCase   #'*ALL'
DeletedUserProfileTestCase   #'*ALL'
DictionaryTestCase   #test_at_put_
DictionaryTestCase   test_removeAssociation_otherwise_
DictionaryTestCase   test_removeKey_ifAbsent_
DictionaryTestCase   test_removeKey_otherwise_
DoubleByteStringTestCase   testBug34006
DoubleByteStringTestCase  test_addAll_
DoubleByteStringTestCase   test_addLast_
DoubleByteStringTestCase   test_add_
DoubleByteStringTestCase   test_at_put_1
DoubleByteStringTestCase   test_copyFrom_to_into_startingAt_1
DoubleByteStringTestCase   test_insertAll_at_1
DoubleByteStringTestCase   test_size_
EphemeronTestCase   testCommitedEphemeron
ExceptionSignalerTestCase   test_signal_03
ForwarderBugsTestCase   #testBug33352
GarbageCollectionTestCase   test34891
GarbageCollectionTestCase   test45640
GciInterfaceTestCase   #'*ALL'
GciLibraryTestCase #testGciAbort
GciLibraryTestCase #testGciBegin
GciLibraryTestCase #testGciCommit
GciLibraryTestCase testGciSetSessionId
GsBitmapTestCase   test_C_fileInfo_
GsBitmapTestCase   test_firstObjectThatReferences_
GsBitmapTestCase   test_readFromFile_withLimit_startingAt_
GsBitmapTestCase   test_referencedObjects
GsExternalSessionTests   test_forkBlock_with_
GsExternalSessionTests   test_forkBlock_with_with_
GsExternalSessionTests   test_loggingToClient
GsExternalSessionTests  test_send_to_
GsExternalSessionTests test_send_to_withArguments_0
GsExternalSessionTests #testDefaultSessionDescription
GsExternalSessionTests #testDefaultSessionDescription2
GsExternalSessionTests #test_suppressLogging
GsFileInTestCase #test_commit
GsFileTestCase   testClientReadsAndWrites
GsFileTestCase   testServerReadsAndWrites
GsFileTestCase   testLegacyInstances
GsFileInTestCase #test_ignored 
GsNetworkResourceStringTestCase #testCustomGem
GsNetworkResourceStringTestCase #testGemNRSForNetLDI_
GsNetworkResourceStringTestCase #testGemNRSForNetLDI_onHost_
GsNetworkResourceStringTestCase #testGemNRSForNetLDI_onHost_gemService_
GsNetworkResourceStringTestCase #testLog
GsNetworkResourceStringTestCase #testSampleGemOnGemHost
GsNetworkResourceStringTestCase #testStoneNRSForStoneName_
GsNetworkResourceStringTestCase #testStoneNRSForStoneName_onHost_
GsNetworkResourceStringTestCase #test_C_gemNRS
GsObjectSecurityPolicyTestCase   #'*ALL' 
GsPipeTestCase   #'*ALL'
GsReferencePathParentsInfoTestCase   #'*ALL'
IcuSortedCollectionTestCase    test4
IcuSortedCollectionTestCase    test5
IdentityBagTestCase    testBug32788
IdentityDictionaryTestCase   test_at_put_
InvariantArrayTestCase   #'*ALL'
InvariantStringTestCase   #'*ALL'
InterSessionSignalTestCase  #'*ALL'
LdapDirectoryServerTestCase   #'*ALL'
ObjectInventoryTestCase   #'*ALL'
ObjectsCommittedNotificationTestCase   #'*ALL'
ObjectTestCase   test_47176
ObjectTestCase   test_objectSecurityPolicy_
OrderedCollectionTestCase   #'*ALL'
PassiveObjectTestCase   testBug42596
QuadByteStringTestCase   test_addAll_
QuadByteStringTestCase   test_addLast_
QuadByteStringTestCase   test_add_
QuadByteStringTestCase   test_at_put_1
QuadByteStringTestCase   test_copyFrom_to_into_startingAt_1
QuadByteStringTestCase   test_insertAll_at_1
QuadByteStringTestCase   test_size_
RcArrayTestCase   #'*ALL'
RcPipeTestCase   #'*ALL'
RcQueueTestCase   #'*ALL'
RunTimeErrorsTestCase   cannotChangePassword
RunTimeErrorsTestCase   testCannotChangeObjectSecurityPolicy
RunTimeErrorsTestCase   testCannotChangePassword
RunTimeErrorsTestCase   testGroupCollectionTooLarge
RunTimeErrorsTestCase   testPoolDictionaries
RunTimeErrorsTestCase   testUserIdAlreadyExists
RunTimeErrorsTestCase   testUserProfileGroupsFull
RunTimeErrorsTestCase   testInvariant
Schema32TestCase   testBug43311
Schema32TestCase   testBug6951
Schema32TestCase   testSchemaModification
Schema32TestCase   test_become_38058
SequenceableCollectionTestCase   #'*ALL'
SortedCollectionTestCase   testBug41323
SortedCollectionTestCase   test_addAll_
SortedCollectionTestCase   test_add_
SortedCollectionTestCase   test_atAllPut_
SortedCollectionTestCase   test_size_
SortedCollectionTestCase   test__addLast_
SortedCollectionTestCase   test__at_put_
SortedCollectionTestCase   test__insertAll_at_
StringTestCase   test_addAllBytes_1
StringTestCase   test_addAll_2
StringTestCase   test_addLast_1
StringTestCase   test_add_2
StringTestCase   test_at_put_1
StringTestCase   test_codePointAt_put_
StringTestCase   test_copyFrom_to_into_startingAt_1
StringTestCase   test_insertAll_at_1
StringTestCase   test_removeFrom_to_
StringTestCase   test_size_1
SymbolDictionaryTestCase   test_at_put_
TimeZoneTestCase   test_C_default_
TransactionBacklogTestCase   #'*ALL'
Unicode16TestCase   test_addLast_
Unicode16TestCase   test_copyFrom_to_into_startingAt_1
Unicode16TestCase   test_insertAll_at_1
Unicode16TestCase   test_size_
Unicode32TestCase   test_addLast_
Unicode32TestCase   test_copyFrom_to_into_startingAt_1
Unicode32TestCase   test_insertAll_at_1
Unicode32TestCase   test_size_
Unicode7TestCase   test_copyFrom_to_into_startingAt_1
Unicode7TestCase   test_insertAll_at_1
Unicode7TestCase   test_size_
UnorderedCollectionTestCase   #'*ALL'
UserProfileSetTestCase   #'*ALL'
UserProfileTestCase   testBug44472
UserProfileTestCase   test_44433
UserProfileTestCase   test_47327
UserProfileTestCase   test_disable
UserProfileTestCase   test_enableLDAPAuthenticationWithAlias_baseDn_filterDn_
UserProfileTestCase   test_loginHook_
UserProfileTestCase   test_paramDisableLoginFailureLimit
UserProfileTestCase   test_userId_password_
UserProfileTestCase   test_C_disableCommits
UserProfileTestCase   test_disableCommits
UserProfileTestCase   test_enableX509
Bug40410   test
Bug40921   test
Bug47291   test
BugTst1TestCase  test_softBreak_47604
BugTst1TestCase   test0068a
BugTst1TestCase   test0097
BugTst1TestCase   test0125
BugTst1TestCase   test0210
BugTst1TestCase   test0216
BugTst1TestCase   test0220
BugTst1TestCase   test0235
BugTst1TestCase   test0258
BugTst1TestCase   test0259
BugTst1TestCase   test0280
BugTst1TestCase   test0282
BugTst1TestCase   test0333
BugTst1TestCase   test_43957
BugTst2TestCase   test0429
BugTst2TestCase   test0453
BugTst2TestCase   test0454
BugTst2TestCase   test0500
BugTst2TestCase   test0570
BugTst3TestCase   testBug0591
BugUser1TestCase   #'*ALL'
BugUser3TestCase   testBug0993
BugUser3TestCase   testBug1090
BugUser3TestCase   testBug1105
BugUser3TestCase   testBug1110
BugUser3TestCase   testBug1111
BugUser3TestCase   testBug1144
BugUser3TestCase   testBug1255
BugUser3TestCase   testBug1318
BugUser4TestCase   testBugObjectSecurityPolicies
BugUser4TestCase   testBehavior_at_put_basicAt_put_instVarAt_put_size_
BugUser4TestCase   testCompiledMethod_at_put_basicAt_put_instVarAt_put_size_
BugUser6TestCase   #'*ALL'
GsProcessTestCase   slave45307
GsProcessTestCase   test45307
GsProcessTestCase   testBug40712
GsProcessTestCase  test48016
GsSocketTestCase   test_getStandardId_inband_
GsSecureSocketTestCase   test_getStandardId_inband_
GsSecureSocketTestCase   test_readReady
GsSingleRefPathFinderTestCase testBug48447
GsSignalingSocketTestCase   test_readReady
GsSocketTestCase   test_readReady
Bug47796  test_1
PositionableStream_Legacy test_match
).
].
%
