/*========================================================================
 * Written by D. Jason Penney, 1991.  Rights to this program are as follows:
 * you may not receive any compensation for distribution of this program
 * except for an optional fee for the distribution medium.  This program
 * must be accompanied by this source code.  This notice may not be removed.
 * Modifications to this program must be clearly noted and marked as such.
 * Since this program is provided free of charge, there is ABSOLUTELY NO
 * WARRANTY.
 *
 * Name - getpwnam.c
 *
 * Description - 
 *
 * Compile with:
 *   cc -o getpwnam getpwnam.c
 *   chmod 555 getpwnam
 *
 * $Id$
 *
 * $Log: not supported by cvs2svn $
 * Revision 1.3  2007/04/12 06:52:42  otisa
 * change to compile with C++ for fix 36569
 *
 * Revision 1.2  2005/05/18 22:58:20  normg
 * Initial checkin for 64 linux support
 *
 * Revision 1.1.1.1  2004/01/05 23:55:12  normg
 * inital 64 bit import
 *
 * Revision 50.1.1.1  1995/08/08 23:54:16  darrel
 * 5.0 backend sources
 *
 * Revision 41.3  1995/03/04 20:30:06  darrel
 * Now compile and link on HPUX.
 *
 * Revision 41.2  1994/11/14  21:17:00  jason
 * Roll forward the NCR changes
 *
 * Revision 41.1  1994/11/02  22:40:38  jason
 * Added asyncio and getpwnam
 *
 * Revision 1.1.1.2  1992/11/03  18:44:58  penneyj
 * many fixes
 *
 * Revision 1.1.1.1  1991/05/01  19:40:38  penneyj
 * *** empty log message ***
 *
 * Revision 1.1  1991/05/01  19:40:37  penneyj
 * Initial revision
 *
 *========================================================================
 */

#if defined(__hpux)
#if !defined(_HPUX_SOURCE)
#define _HPUX_SOURCE
#endif /* !defined(_HPUX_SOURCE) */
#include <sys/stdsyms.h> /* Pick up the other related #defs */
#endif

#include <stdio.h>
#include <pwd.h>
#include <ctype.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{

if (argc != 2) {
  printf("Usage: %s <user-name>\n", argv[0]);
  exit(1);
  }

struct passwd *pw = getpwnam(argv[1]);
if (pw == NULL) {
  printf("%s:  (no entry, errno = %d)\n", argv[1], errno);
  exit(1);
  }

printf("pw_name='%s', pw_passwd='%s', pw_uid=%d, pw_gid=%d\n",
    pw->pw_name, pw->pw_passwd, pw->pw_uid, pw->pw_gid);

#if defined(_IBMR2) || defined(linux) || defined(__APPLE_CC__) || defined(__APPLE_CPP__)
#else
printf("pw_age='%s', pw_comment='%s'\n", pw->pw_age, pw->pw_comment);
#endif

printf("pw_gecos='%s', pw_dir='%s', pw_shell='%s'\n",
    pw->pw_gecos, pw->pw_dir, pw->pw_shell);
return 0;
}
