!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

removeallmethods Error
removeallclassmethods Error

category: 'For Documentation Installation only'
classmethod: Error
installDocumentation

self comment:
'The class protocol describe the behavior of the global Error. The value 
of the standard global Error is a class object that conforms to this 
protocol. The class Error is explicitly specified to be subclassable in 
a standard conforming program. Conforming implementations must implement 
its behaviors in a non-fragile manner.

The signaled exceptions generated by this type of object conform to the 
protocol <Error>.

The instance protocol describes the behavior of instances of class Error. 
These are used to represent error conditions that prevent the normal 
continuation of processing. Actual error exceptions used by an application 
may be subclasses of this class.

As Error is explicitly specified to be subclassable, conforming 
implementations must implement its behavior in a non- fragile manner.'.
%

category: 'ANSI - signaledException'
method: Error
defaultAction
	"The current computation is terminated. The cause of the error should be
	logged or reported to the user. If the program is operating in an interactive
	debugging environment the computation should be suspended and the 
	debugger activated."

	^super defaultAction.
%

category: 'ANSI - exceptionDescription'
method: Error
isResumable
	"Error exceptions by default are assumed to not be 'resumable.' 
	Subclasses may override this definition for situations where it is
	appropriate for an error to be resumable."

	^false.
%
