expectvalue /String
run
(Object subclass: 'GciTsLibrary' 
  instVarNames:#( version callouts calloutSigs cLibrary )
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options:#() ) definition
%
set class GciTsLibrary
removeallmethods
removeallclassmethods

classmethod
comment
^ 'A GciTsLibrary represents a loaded CLibrary for ffi access to the
   thread safe GCI functions in $GEMSTONE/include/gcits.hf. '
%

classmethod: 
newForVersion: verString product: pathArg
  | res hdr path hdrPath libPath suffix |
  (res := self new )
    version: verString . "checks verString"
  path := pathArg.
  path last == $/ ifFalse:[ (path := path copy) add: $/ ].
  hdrPath := path, 'include/gcits.hf'  .
  suffix := ((System gemVersionReport at: 'gsBuildArchitecture') at:1 equals:'Darwin')
             ifTrue:[ '-64.dylib' ] ifFalse:[ '-64.so' ].
  libPath := path, 'lib/libgcits-', (res version), suffix .
  hdr := CHeader path: hdrPath .
  res 
    libPath: libPath ;
    _initCallouts: hdr .
  ^ res 
%
classmethod:
newDefault
  | ver |
  ver := System _gemVersion  .
  ^ self newForVersion: ver product: '$GEMSTONE'
%
method:
callouts
  ^ callouts
%
method:
version: verString
  "can't yet load v3.4.x libs into a 3.5 VM , see bug 48749" 
  | ok ofs vs |
  ofs := (vs := verString) indexOf: $, startingAt: 1 .
  ofs > 0 ifTrue:[ 
    vs := vs copyFrom: 1 to: ofs - 1 .
  ].
  ok := false .
  (vs at: 1 equals: '3.5') ifTrue:[ 
     vs := vs copyFrom: 1 to: 5 .
     ok := vs >= '3.5.3' . 
  ] ifFalse:[ | v |
    ofs := vs indexOf: $. startingAt: 1 .
    ofs > 0 ifTrue:[
      ofs := vs indexOf: $. startingAt: ofs + 1  . "second . "
      ofs > 0 ifTrue:[
        v := Float fromString:(vs copyFrom: 1 to: ofs - 1 ) .
        ok :=   v >= 3.6 .
      ].
    ]. 
  ].
  ok ifTrue:[ version := vs ]
     ifFalse:[ Error signal:'Cannot load library that has version ', verString].
%
method:
version
 "Returns a String of the form  3.5.5 "
  ^ version
%
method:
libPath: aPath
  cLibrary := CLibrary named: aPath .
%
method:
_initCallouts: aCHeader
 | fcts list |
 callouts := { } .
 calloutSigs := { } .
 fcts := aCHeader functions .
 list := #( 
    'GciTsLogin'  "order of list must match offsets used in GsTsExternalSession"
    'GciTsLogout'
    'GciTsAbort'
    'GciTsCommit'
    'GciTsExecute'
    'GciTsPerform'
    'GciTsContinueWith' "7"
    'GciTsClearStack' 
    'GciTsFetchObjInfo'
    'GciTsNbLogout'  "10"
  ) copy .
  version >= '3.5.3' ifTrue:[ 
   list addAll: #( 
    'GciTsNbPerform' "11"
    'GciTsNbResult'
    'GciTsSocket' 
    'GciTsNbExecute' )
  ].
  "todo, add more functions"
  list  do:[ :fn | | f c |
   f := fcts at: fn .
   c := (f cCalloutForLibrary: cLibrary) copy .
   c coerceNameToSymbol . "for efficient consistency checks in GsTsExternalSession"
   callouts add: c .
   calloutSigs add: c signatureString .
 ].
% 
