expectvalue /Class
doit
Array subclass: 'InstVarMappingArray'
  instVarNames: #( dynamicIvsToNamed namedIvsToDynamic preserveDynamic )
  classVars: #( )
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
%
expectvalue /Class
doit
InstVarMappingArray comment: 
'InstVarMappingArray is used in instance migration to control
 migration of both named and dynamic instanceVaribles.

 instance variables  
   preserveDynamic    aBoolean

   varying instanceVariables 
     1: a SmallInteger,  offset of instVar in old object corresponding to instVarAt: 1 in new object
     ...
'
%
! ------------------- Remove existing behavior from CPreprocessor
expectvalue /Metaclass3       
doit
InstVarMappingArray removeAllMethods.
InstVarMappingArray class removeAllMethods.
%
set class InstVarMappingArray

category: 'Instance Creation'
classmethod:
mappingFrom: oldClass to: newClass
 "Creates an instance that preserves dynamic instVars of instances of oldClass.
  Named instVars in oldClass that do not exist in newClass are not preserved.

  Use InstVarMappingArray class >> new  followed by 
      InstVarMappingArray >> initializeFrom:to:preserveDynamic:
  to customize a mapping . "

^ self new initializeFrom: oldClass to: newClass 
%
category: 'Accessing'
method:
preserveDynamic
  ^ preserveDynamic
%

category: 'Updating'
method:
preserveDynamic: aBoolean
  preserveDynamic := aBoolean
%


category: 'Initialization'
method:
initializeFrom: oldClass to: newClass preserveDynamic: aBoolean 
  "Initializes the receiver for subsequent use as receiver of copyIvsFrom:to: .

   If aBoolean==true, dynamic instance variables are preserved in the
   new instance, if false, dynamic instance variables are not preserved. "

  preserveDynamic := aBoolean .
  self addAll: (newClass instVarMappingTo: oldClass) .
%

method:
initializeFrom: oldClass to: newClass

^ self initializeFrom: oldClass to: newClass preserveDynamic: true
%

