!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   SystemLoginNotification, Object
!
!=========================================================================

expectvalue %String
doit
| oldCls newCls |
oldCls := Globals at:#SystemLoginNotification otherwise: nil .
oldCls == nil ifTrue:[
  Object  _newKernelSubclass: #SystemLoginNotification
    instVarNames: #()
    classVars: #( Subscriptions)
    classInstVars: #()
    poolDictionaries: { }
    inDictionary: Globals
    options: #() 
    reservedOop: nil.
  "move the association for Subscriptions into GsObjectSecurityPolicy 0"
  ((newCls := Globals at:#SystemLoginNotification) _classVars associationAt: #Subscriptions) objectSecurityPolicy: nil.
  ^ 'created new class: ' , newCls definition
] ifFalse:[
  ^ 'existing class: ' , oldCls definition
]
%

! Remove existing behavior from SystemLoginNotification
doit
SystemLoginNotification removeAllMethods.
SystemLoginNotification class removeAllMethods.
true
%
! ------------------- Class methods for SystemLoginNotification
category: 'notification'
classmethod: SystemLoginNotification
sessionStart
    "Nothing by default"
%
