!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

set class Warning

! no removeall
!  Warning>>initialize in  Exception.gs

category: 'Documentation'
classmethod: Warning
comment

^
'Instances of Warning implement the ANSI protocol <Warning>.

 Warning is used to represent exceptional conditions that 
 might occur that are not considered errors but which should be 
 reported to the user. Typically, the actual warning exceptions 
 used by an application will be subclasses of this class.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object' 
%

category: 'ANSI - signaledException'
method: Warning
defaultAction
  "The user should be notified of the occurrence of an exceptional
  occurrence and given an option of continuing or aborting the
  computation. The description of the occurrence should include
  any text specified as the argument of the #signal: message.

  Client Smalltalks put up a dialog box here. Gemstone does nothing;
  Gemstone applications could change this behavior by subclasses ..."

  " GsFile gciLogServer:'Warning: ' , self asString .  "
  ^ super defaultAction .
%
