!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
!=========================================================================

! fix 47420
expectvalue /String
run
(Character classVarAt: 'Backspace' otherwise: nil) ifNil:[ | arr |
  arr := { 
    #Backspace . Character codePoint: 8  .
    #Lf . Character codePoint: 10 .
    #Cr . Character codePoint: 13 .
    #Esc . Character codePoint: 27 .
    #NewPage . Character codePoint: 12 .
    #Tab . Character codePoint: 9 . }.
  1 to: arr size by: 2 do:[:j |
    Character _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
  ]. 
  ^ 'added'
].
^ 'no change'
%

set class Character

category: '*PetitParser-Core-Operators'
set compile_env: 0
method: 
to: aCharacter
	"Create a parser for a range of characters between the receiver and the argument."
	
	^ PPPredicateObjectParser between: self and: aCharacter
%
category: '*PetitParser-Core-Converting'
set compile_env: 0
method: 
asParser
	"Answer a parser that accepts the receiving character."
	
	^ PPLiteralObjectParser on: self
%

! recompile some methods with optimized literals
category: 'Non-Printable Characters'
classmethod:
backspace
  "Returns the ASCII back-space Character."
  ^ Backspace
%
classmethod:
lf
  "Returns the ASCII line-feed Character."
  ^ Lf
%
classmethod:
cr
  "Returns the ASCII carriage-return Character."
  ^ Cr
%
classmethod:
esc
  "Returns the ASCII escape Character."
  ^ Esc 
%
classmethod:
newPage
  "Returns the ASCII new-page (form feed) Character."
  ^ NewPage
%
classmethod:
tab
  "Returns the ASCII tab Character."
  ^ Tab
%

category: 'Deprecated'
method: Character
asJISCharacter

"Returns the JISCharacter corresponding to the receiver."

self deprecated: 'Character>>asJISCharacter deprecated v3.0'.
^ JISCharacter withValue: self codePoint 
%

lev 1
run
| arr |
arr := { Character backspace . 
  Character lf .
  Character cr .
  Character esc .
  Character newPage .
  Character tab } collect:[:c | c codePoint ] .
arr = #( 8 10 13 27 12 9 ) ifFalse:[ ^ arr ].
true
%
