!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! ! $Id: date.gs 33174 2014-04-10 22:29:11Z otisa $
!
! Superclass Hierarchy:
!   Date, Magnitude, Object.
!
!=========================================================================

! This method needs to come after the DateAndTime class is defined

category: 'Instance Creation'
classmethod: Date
today

  "Returns an instance of the receiver representing the current Date, taking into 
   consideration the current GemStone TimeZone.  

   See Date class >>_today for 3.2.x and earlier implementation that gets date 
   directly from the OS and does not reflect repository TimeZone."

   | parts |
   parts := DateAndTime now asFloatParts.  
     "parts is { year. dayOfYear. monthIndex. dayOfMonth. hour. minute. second } "
   ^self newDay: (parts at: 4) monthNumber: (parts at: 3) year: (parts at: 1).
%
