!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   InvariantString, String, CharacterCollection, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

removeallmethods InvariantString
removeallclassmethods InvariantString

category: 'For Documentation Installation only'
classmethod: InvariantString
installDocumentation

self comment:
'InvariantString is a subclass of String for which all instances are
 immutable after they are committed.'.
%

category: 'Formatting'
method: InvariantString
asString

"Returns a copy of the receiver as an instance of class String."

^ String withAll: self
%

category: 'Formatting'
method: InvariantString
_quoted

"Returns a copy of the receiver enclosed in single-quote marks, with contained
 single-quote Characters doubled.  The copy will be of class String.  This is
 usually done to prepare a storable version of the receiver."

| result c rs sz |

sz := self size.
result := String new: sz + 2.
result at: 1 put: $'.
rs := 1.
1 to: sz do: [:i |
  (c := self at: i) == $' ifTrue: [
    rs := rs + 1.
    result at: rs put: $'.
  ].
  rs := rs + 1.
  result at: rs put: c.
].
rs := rs + 1.
result at: rs put: $'.
^result
%

method: InvariantString
species
  "(R) Returns a class similar to, or the same as, the receiver's class which
   can be used for containing derived copies of the receiver."

  ^ String
%

