category: '*gsmonticello'
method: Collection
gather: aBlock
	^ Array streamContents:
		[:stream |
		self do: [:ea | stream nextPutAll: (aBlock value: ea)]]
%

category: '*gsmonticello'
method: Collection
copyWithoutAll: aCollection
	"Answer a copy of the receiver that does not contain any elements 
	equal to those in aCollection."

	^ self reject: [:each | aCollection includes: each]
%

category: '*gsmonticello'
method: Collection
max
	^ self inject: self anyOne into: [:max :each | max max: each]
%

category: '*gsmonticello'
method: Collection
anyOne
	"Answer a representative sample of the receiver. This method can
	be helpful when needing to preinfer the nature of the contents of 
	semi-homogeneous collections."

	self size == 0 ifTrue: [self errorEmptyCollection].
	self do: [:each | ^ each]
%

category: '*gsmonticello'
method: Collection
sortBy: aBlock

    ^self sortWithBlock: aBlock
%

category: '*gsmonticello'
method: Collection
do: elementBlock separatedBy: separatorBlock
	"Evaluate the elementBlock for all elements in the receiver,
	and evaluate the separatorBlock between."

	| beforeFirst | 
	beforeFirst := true.
	self do:
		[:each |
		beforeFirst
			ifTrue: [beforeFirst := false]
			ifFalse: [separatorBlock value].
		elementBlock value: each]
%
