expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #SharedPool otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'SharedPool'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'SharedPool') .
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods SharedPool
removeallclassmethods SharedPool

category: 'name lookup'
classmethod: SharedPool
bindingOf: varName
	"Answer the binding of some variable resolved in the scope of the receiver"
	| aSymbol binding |
	aSymbol := varName asSymbol.

	"First look in classVar dictionary."
	binding := self classPool bindingOf: aSymbol.
	binding ifNotNil:[^binding].

	"Next look in shared pools."
	self sharedPools do:[:pool | 
		binding := pool bindingOf: aSymbol.
		binding ifNotNil:[^binding].
	].

	"subclassing and environment are not preserved"
	^nil
%
run
SharedPool class setStamp: 'ar 5/18/2003 17:46' forMethod: #bindingOf:.
true
%

category: 'name lookup'
classmethod: SharedPool
bindingsDo: aBlock
	^self classPool bindingsDo: aBlock
%
run
SharedPool class setStamp: 'ar 5/18/2003 20:33' forMethod: #bindingsDo:.
true
%

category: 'name lookup'
classmethod: SharedPool
classBindingOf: varName
	"For initialization messages grant the regular scope"
	^super bindingOf: varName
%
run
SharedPool class setStamp: 'ar 5/18/2003 18:14' forMethod: #classBindingOf:.
true
%

category: 'name lookup'
classmethod: SharedPool
hasBindingThatBeginsWith: aString
	"Answer true if the receiver has a binding that begins with aString, false otherwise"

	"First look in classVar dictionary."
	(self classPool hasBindingThatBeginsWith: aString) ifTrue:[^true].
	"Next look in shared pools."
	self sharedPools do:[:pool | 
		(pool hasBindingThatBeginsWith: aString) ifTrue: [^true]].
	^false
%
run
SharedPool class setStamp: 'tween 9/13/2004 10:10' forMethod: #hasBindingThatBeginsWith:.
true
%

category: 'name lookup'
classmethod: SharedPool
includesKey: aName
	"does this pool include aName"
	^(self bindingOf: aName) notNil
%
run
SharedPool class setStamp: 'tpr 5/29/2003 18:12' forMethod: #includesKey:.
true
%

category: 'enumerating'
classmethod: SharedPool
keysDo: aBlock
"A hopefully temporary fix for an issue arising from miss-spelled variable names in code being compiled. The correction code (see Class>possibleVariablesFor:continuedFrom: assumes that sharedPools are Dictionaries. The proper fix would involve making sure all pools are actually subclasses of SharedPool, which they are not currently."
	self bindingsDo:[:b|
		aBlock value: b key]
%
run
SharedPool class setStamp: 'tpr 12/14/2004 12:34' forMethod: #keysDo:.
true
%

