!=========================================================================
! Copyright (C) GemTalk Systems 2010-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

set class ObsDoubleByteString
removeallmethods
removeallclassmethods

category: 'Documentation'
classmethod: 
comment
^ '
 ObsDoubleByteString is a string with 2 bytes per Character,
 stored on disk in big endian byte order.   In a v2.x VM ,the
 string was big endian in memory and on disk; on a little-endian
 CPU, bytes were swapped before doing 16bit character comparisons.

 In a 3.0 VM, Instance creation is disallowed.
 Instances are automatically mutated to instances of DoubleByteString
 when faulted into a v3.0 VM.'
%

category: 'Instance creation'
classmethod: 
new
  self shouldNotImplement: #new
%
classmethod: 
new: aSize
  self shouldNotImplement: #new:
%
category: 'Instance creation'
classmethod: 
_basicNew
  self shouldNotImplement: #_basicNew
%
classmethod: 
_basicNew: aSize
  self shouldNotImplement: #_basicNew: 
%


