!=========================================================================
! Copyright (C) GemTalk Systems 2013-2020.  All Rights Reserved.
!
! $Id: optionalpathterm.gs 31614 2013-10-09 17:47:16Z dhenrich $
!
! Superclass Hierarchy:
!   OptionalPathTerm, PathTerm, Array, SequenceableCollection, 
!   Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods OptionalPathTerm
removeallclassmethods OptionalPathTerm

category: 'For Documentation Installation only'
classmethod: OptionalPathTerm
installDocumentation

self comment: '
OptionalPathTerm represents a single term/instance variable within an index or query
path, in which is it not required that the instance variable be present on the instances of
the referencing class.  This supports the optionPathTerms query and index features.

OptionalPathTerm implements only GemStone internals, and is not intended for direct use
by customers.
'.
%

category: 'Private'
set compile_env: 0
method: OptionalPathTerm
_mapInfoOrErrorForMissingIvOffset: anObject
  "If missing path slots are tolerated, return an empty MappingInfo. Otherwise 
   return an error array"

  ^ self _mappingInfoClass new pathTerm: self
%
category: 'Accessing'
set compile_env: 0
method: OptionalPathTerm
_nextObjectFor: anObject
  "Returns the object at the instance variable that corresponds to the receiver
 path term."

  | ivOffset |
  ivOffset := self _ivOffsetFor: anObject.
  ivOffset ifNil: [ ^ nil ].
  ^ self _nextObjectFor: anObject atInstVar: ivOffset
%
category: 'Audit'
set compile_env: 0
method: OptionalPathTerm
auditDepListFor: obj index: indexObj on: aString
  "Obsolete...use PathTerm>>auditDepListFor:index:on:optionalSentinel: instead"

  self shouldNotImplement: #'auditDepListFor:index:on:'
%
category: 'Testing'
set compile_env: 0
method: OptionalPathTerm
isOptionalTerm
  ^ true
%
category: 'Traversing'
method: OptionalPathTerm
_getNextObjectForTraversal: anObject
  " get the next object along the path "

  | ivOffset nextObj |
  ivOffset := anObject _findIVOffsetForPathTerm: self.
  ivOffset == nil
    ifTrue: [ nextObj := nil ]
    ifFalse: [ nextObj := anObject instVarAt: ivOffset ].
  ^ nextObj
%
category: 'Accessing'
method: OptionalPathTerm
requirePathTerms
  "If missing path slots are tolerated, answer false"

  ^ false
%
category: 'Testing'
method: OptionalPathTerm
termsRequired
  "Answer true if receiver requires that instance variables of indexed objects are present "

  ^ false
%
