!=========================================================================
! Copyright (C) GemTalk Systems 2013-2020.  All Rights Reserved.
!=========================================================================

doit
"CharacterCollection>>#'asParser'
	We have this instead of String>>#'asParser'
Collection>>#'asParser'
	We use #'isKindOf:' instead of #'isCharacter'
DoubleByteSymbol>>#'asParser'
	We added this
Interval>>#'asParser'
	We use #'isKindOf:' instead of #'isCharacter'
PositionableStream
	#'peekTwice' and #'asPetitStream' moved to PositionableStreamPortable
PositionableStreamPortable>>#'collection'
	We added as compatibility with PositionableStream in Pharo/Squeak
PPActionParser>>#'setBlock:'
	Modified to support Symbol as argument
PPCompositeParser>>#'productionAt:ifAbsent:'
	Remove #'asString' since we store instVarNames as symbols
PPForwardingParser
	We use this instead of #'becomeForward:' in PPParser>>#'def:'
PPLiteralObjectParser>>#'caseInsensitive'
	We use #'isEquivalent:' instead of #'sameAs:'
PPLiteralSequenceParser>>#'caseInsensitive'
	We use #'isEquivalent:' instead of #'sameAs:'
PPParser>>#'def:'
	Modified since we don't have #'becomeForward:'
PPParser>>#'queryToken'
	Added to support GsQueryTokenParser
PPRepeatingParser>>#'initialize'
	Modified to use #'maximumValue' instead of #'maxValue'
PPRepeatingParser>>#'printOn:'
	Modified to use #'maximumValue' instead of #'maxValue'
PPSequenceParser>>#'permutation:'
	Modified to use #'_isInteger' instead of #'isInteger'
PPStream
	Superclass changed to ReadStream Portable
PPStream>>#'back' and #'peekBack'
	Added to match Pharo/Squeak PositionableStream
PPStream>>#'printOn:'
	Modified to avoid non-Ascii character in source code
PPToken
	Remove NewLineParser from class variable (permissions and commit conflicts)
QuadByteSymbol>>#'asParser'
	Added
String>>#'asParser'
	Moved to CharacterCollection
Text>>#'asPetitStream'
	Not supported

PPParser>>#'matchingRangesIn:do:'
	Should change to match since no recognizable difference
"
true
%

expectvalue %String
doit
(Object subclass: 'PPContext'
  instVarNames: #( stream root properties globals furthestFailure)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPContext
doit
PPContext comment: 
'A PPContext is provides contextual information to the parsing function.

Instance Variables
	globals:		<Dictionary>
	properties:		<Dictionary>
	root:		<PPParser>
	stream:		<PPStream>
	furthestFailure:	<PPFailure>

globals
	- properties that are not restored after backtracking

properties
	- properties that are restored after backtracking

root
	- the root parser

stream
	- input stream
'.
true
%

expectvalue %String
doit
(Object subclass: 'PPContextMemento'
  instVarNames: #( stream position properties)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%


expectvalue %String
doit
(Object subclass: 'PPCharSetPredicate'
  instVarNames: #( block classification)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %String
doit
(Object subclass: 'PPFailure'
  instVarNames: #( message context position)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPFailure
doit
PPFailure comment: 
'The failure object in PetitParser. It is the only class that responds to #isPetitFailure with true. It contains an error message and a position of the occurrence of the failure.

Instance Variables:
	message	<String>	The error message of this failure.
	position	<Integer>	The position of this failure in the input stream.
'.
true
%

expectvalue %String
doit
(Object subclass: 'PPForwardingParser'
  instVarNames: #( forwardee)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPForwardingParser
doit
PPForwardingParser comment: 
'Forwards (almost) all messages to its forwardee parser, making them for most purposes the same object.
This is used to simulate the one-way become that is used in other ports of PetitParser to resolve parsers.'.
true
%

expectvalue %String
doit
(Object subclass: 'PPMemento'
  instVarNames: #( result count context)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPMemento
doit
PPMemento comment: 
'PPMemento is an internal class used by PPMemoizedParser to cache results and detect left-recursive calls.

Instance Variables:
	result	<Object>	The cached result.
	count	<Integer>	The number of recursive cycles followed.
	context	<PPContext>	The context of the cached result in the input stream.'.
true
%

expectvalue %String
doit
(Object subclass: 'PPParser'
  instVarNames: #( properties)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPParser
doit
PPParser comment: 
'An abstract parser for all parsers in PetitParser. Subclasses implement #parseOn: to perform the actual recursive-descent parsing. All parsers support a variety of methods to perform an actual parse, see the methods in the #parsing protocol. Parsers are combined with a series of operators that can be found in the #operations protocol.

Instance Variables:
	properties	<Dictionary>	Stores additional state in the parser object.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPDelegateParser'
  instVarNames: #( parser)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPDelegateParser
doit
PPDelegateParser comment: 
'A parser that delegates to another parser.

Instance Variables:
	parser	<PPParser>	The parser to delegate to.'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPActionParser'
  instVarNames: #( block)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPActionParser
doit
PPActionParser comment: 
'A parser that performs an action block with the successful parse result of the delegate.

Instance Variables:
	block	<BlockClosure>	The action block to be executed.
'.
true
%

expectvalue %String
doit
(PPActionParser subclass: 'PPWrappingParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPWrappingParser
doit
PPWrappingParser comment: 
'A parser that performs an action block upon activation with the stream and a continuation block.'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPAndParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPAndParser
doit
PPAndParser comment: 
'The and-predicate, a parser that succeeds whenever its delegate does, but does not consume the input stream [Parr 1994, 1995].'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPCompositeParser'
  instVarNames: #(dependencies)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPCompositeParser
doit
PPCompositeParser comment: 
'A PPCompositeParser is composed parser built from various primitive parsers. 

Every production in the receiver is specified as a method that returns its parser. Note that every production requires an instance variable of the same name, otherwise the production is not cached and cannot be used in recursive grammars. Productions should refer to each other by reading the respective inst-var. Note: these inst-vars are typically not written, as the assignment happens in the initialize method using reflection.

The start production is defined in the method start. It is aliased to the inst-var parser defined in the superclass of PPCompositeParser.'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPConditionalParser'
  instVarNames: #(block)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPConditionalParser
doit
PPConditionalParser comment: 
'A PPConditionalParser is a delegate parser that evaluates a block and if that returns true, the delegate parser is invoked and its result returned. If the block evaluates to false, the PPFailure is returned.

The block accepts one argument, context.

E.g.
    (''a'' asParser if: [ :ctx | (ctx propertyAt: #myProperty) isNotNil ]) parse: ''a'''.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPEndOfInputParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPEndOfInputParser
doit
PPEndOfInputParser comment: 
'A parser that succeeds only at the end of the input stream.'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPExpressionParser'
  instVarNames: #( operators)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPExpressionParser
doit
PPExpressionParser comment: 
'A PPExpressionParser is a parser to conveniently define an expression grammar with prefix, postfix, and left- and right-associative infix operators.

The following code initializes a parser for arithmetic expressions. First we instantiate an expression parser, a simple parser for expressions in parenthesis and a simple parser for integer numbers.

	expression := PPExpressionParser new.
	parens := $( asParser token trim , expression , $) asParser token trim 
		==> [ :nodes | nodes second ].
	integer := #digit asParser plus token trim
		==> [ :token | token value asInteger ].
	
Then we define on what term the expression grammar is built on:

	expression term: parens / integer.
	
Finally we define the operator-groups in descending precedence. Note, that the action blocks receive both, the terms and the parsed operator in the order they appear in the parsed input. 
	
	expression
		group: [ :g |
			g prefix: $- asParser token trim do: [ :op :a | a negated ] ];
		group: [ :g |
			g postfix: ''++'' asParser token trim do: [ :a :op | a + 1 ].
			g postfix: ''--'' asParser token trim do: [ :a :op | a - 1 ] ];
		group: [ :g |
			g right: $^ asParser token trim do: [ :a :op :b | a raisedTo: b ] ];
		group: [ :g |
			g left: $* asParser token trim do: [ :a :op :b | a * b ].
			g left: $/ asParser token trim do: [ :a :op :b | a / b ] ];
		group: [ :g |
			g left: $+ asParser token trim do: [ :a :op :b | a + b ].
			g left: $- asParser token trim do: [ :a :op :b | a - b ] ].
		
After evaluating the above code the ''expression'' is an efficient parser that evaluates examples like:

	expression parse: ''-8++''.
	expression parse: ''1+2*3''.
	expression parse: ''1*2+3''.
	expression parse: ''(1+2)*3''.
	expression parse: ''8/4/2''.
	expression parse: ''8/(4/2)''.
	expression parse: ''2^2^3''.
	expression parse: ''(2^2)^3''.
	
Instance Variables:
	operators	<Dictionary>	The operators defined in the current group.'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPFlattenParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPFlattenParser
doit
PPFlattenParser comment: 
'A parser that answers a flat copy of the range my delegate parses.'.
true
%

expectvalue %String
doit
(PPFlattenParser subclass: 'PPTokenParser'
  instVarNames: #( tokenClass)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPTokenParser
doit
PPTokenParser comment: 
'A parser that answers a token of the range my delegate parses.

Instance Variables:
	tokenClass	<PPToken class>	The token sub-class to be used.'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPMemoizedParser'
  instVarNames: #( buffer identifier)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPMemoizedParser
doit
PPMemoizedParser comment: 
'A memoized parser, for refraining redundant computations.

Instance Variables:
	stream	<PositionableStream>	The stream of the associated memento objects.
	buffer	<Array of: PPMemento>	The buffer of memento objects.
'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPNotParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPNotParser
doit
PPNotParser comment: 
'The not-predicate, a parser that succeeds whenever its delegate does not, but consumes no input [Parr 1994, 1995].'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPOptionalParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPOptionalParser
doit
PPOptionalParser comment: 
'A parser that optionally parsers its delegate, or answers nil.'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPRepeatingParser'
  instVarNames: #( min max)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPRepeatingParser
doit
PPRepeatingParser comment: 
'An abstract parser that repeatedly parses between ''min'' and ''max'' instances of its delegate. The default configuration parses an infinite number of elements, as ''min'' is set to 0 and ''max'' to infinity (SmallInteger maxVal).

Instance Variables:
	min	<Integer>	The minimum number of repetitions.
	max	<Integer>	The maximum number of repetitions.'.
true
%

expectvalue %String
doit
(PPRepeatingParser subclass: 'PPLimitedRepeatingParser'
  instVarNames: #( limit)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPLimitedRepeatingParser
doit
PPLimitedRepeatingParser comment: 
'An abstract parser that repeatedly parses between ''min'' and ''max'' instances of my delegate and that requires the input to be completed with a specified parser ''limit''. Subclasses provide repeating behavior as typically seen in regular expression implementations (non-blind).

Instance Variables:
	limit	<PPParser>	The parser to complete the input with.'.
true
%

expectvalue %String
doit
(PPLimitedRepeatingParser subclass: 'PPGreedyRepeatingParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPGreedyRepeatingParser
doit
PPGreedyRepeatingParser comment: 
'A greedy repeating parser, commonly seen in regular expression implementations. It aggressively consumes as much input as possible and then backtracks to meet the ''limit'' condition.

This class essentially implements the iterative version of the following recursive parser composition:

	| parser |
	parser := PPChoiceParser new.
	parser setParsers: (Array
		with: (self , parser map: [ :each :rest | rest addFirst: each; yourself ])
		with: (limit and ==> [ :each | OrderedCollection new ])).
	^ parser ==> [ :rest | rest asArray ]'.
true
%

expectvalue %String
doit
(PPLimitedRepeatingParser subclass: 'PPLazyRepeatingParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPLazyRepeatingParser
doit
PPLazyRepeatingParser comment: 
'A lazy repeating parser, commonly seen in regular expression implementations. It limits its consumption to meet the ''limit'' condition as early as possible.

This class essentially implements the iterative version of the following recursive parser composition:

	| parser |
	parser := PPChoiceParser new.
	parser setParsers: (Array
		with: (limit and ==> [ :each | OrderedCollection new ])
		with: (self , parser map: [ :each :rest | rest addFirst: each; yourself ])).
	^ parser ==> [ :rest | rest asArray ]'.
true
%

expectvalue %String
doit
(PPRepeatingParser subclass: 'PPPossessiveRepeatingParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPPossessiveRepeatingParser
doit
PPPossessiveRepeatingParser comment: 
'The default repeating parser with standard PEG semantics (i.e. possessive, blind, eager).'.
true
%

expectvalue %String
doit
(PPDelegateParser subclass: 'PPTrimmingParser'
  instVarNames: #( trimmer)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPTrimmingParser
doit
PPTrimmingParser comment: 
'A parser that silently consumes spaces before and after the delegate parser.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPEpsilonParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPEpsilonParser
doit
PPEpsilonParser comment: 
'A parser that consumes nothing and always succeeds.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPEndOfFileParser'
  instVarNames: #( )
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPEndOfFileParser
doit
PPEndOfFileParser comment: 
'A PPEndOfFileParser is parser that will will return true if the stream position is at the end, returns failure otherwise.

The diffirenece between PPEndOfFIleParser and PPEndOfInputParser is:
 - PPEndOfFileParser can be created using #eof asParser
 - PPEndOfInputParser can be created by using parser end
 - PPEndOfFileParser does not delegate to any other parser
 - PPEndOfInputParser parsers its delegate and then decides if the input is at the end.

The PPEndOfFileParser can be used to accept some input only if it is at the end of the input, e.g:

   (''a'' asParser, #eof asParser) parse: ''a''
   (''a'' asParser, #eof asParser) parse: ''aa''
'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPEndOfLineParser'
  instVarNames: #( )
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPEndOfLineParser
doit
PPEndOfLineParser comment: 
'A PPEndOfLineParser is a parser that does not fail, if the stream position is at the end of a line. It does not consume anything.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPFailingParser'
  instVarNames: #( message)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPFailingParser
doit
PPFailingParser comment: 
'A parser that consumes nothing and always fails.

Instance Variables:
	message <String>	The failure message.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPListParser'
  instVarNames: #( parsers)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPListParser
doit
PPListParser comment: 
'Abstract parser that parses a list of things in some way (to be specified by the subclasses).

Instance Variables:
	parsers	<SequenceableCollection of: PPParser>	A sequence of other parsers to delegate to.'.
true
%

expectvalue %String
doit
(PPListParser subclass: 'PPChoiceParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPChoiceParser
doit
PPChoiceParser comment: 
'A parser that uses the first parser that succeeds.'.
true
%

expectvalue %String
doit
(PPChoiceParser subclass: 'PPLimitedChoiceParser'
  instVarNames: #(limit)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPLimitedChoiceParser
doit
PPLimitedChoiceParser comment: 
'A PPLimitedChoiceParser is similar to the choice parser except for the fact, that limit must pass if one of the choices passes. This is similar strategy as with the PPLimitedRepeatingParsers.

This way, one can implement choices that successfully parse this (if limit is filled with ''a''):

(''aa'' // ''a'') ''a'' parse: ''aa''

The limit can be automatically filled using elements from either follow or next set (see methods  PPParser>>followSets or PPParser>>nextSets).

Limit is by default epsilon and therefore it behaves as an ordinary ordered choice.

Instance Variables
	limit:		<Object>

limit
	- xxxxx
'.
true
%

expectvalue %String
doit
(PPListParser subclass: 'PPSequenceParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPSequenceParser
doit
PPSequenceParser comment: 
'A parser that parses a sequence of parsers.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPLiteralParser'
  instVarNames: #( literal message)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPLiteralParser
doit
PPLiteralParser comment: 
'Abstract literal parser that parses some kind of literal type (to be specified by subclasses).

Instance Variables:
	literal	<Object>	The literal object to be parsed.
	message	<String>	The error message to be generated.
'.
true
%

expectvalue %String
doit
(PPLiteralParser subclass: 'PPLiteralObjectParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPLiteralObjectParser
doit
PPLiteralObjectParser comment: 
'A parser that accepts a single literal object, such as a character. This is the same as the predicate parser ''PPPredicateParser expect: literal'' but slightly more efficient.'.
true
%

expectvalue %String
doit
(PPLiteralParser subclass: 'PPLiteralSequenceParser'
  instVarNames: #( size)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPLiteralSequenceParser
doit
PPLiteralSequenceParser comment: 
'A parser accepts a sequence of literal objects, such as a String. This is an optimization to avoid having to compose longer sequences from PPSequenceParser.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPPluggableParser'
  instVarNames: #( block)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPPluggableParser
doit
PPPluggableParser comment: 
'A pluggable parser that passes the parser stream into a block. This enables users to perform manual parsing or to embed other parser frameworks into PetitParser.

Instance Variables:
	block	<BlockClosure>	The pluggable one-argument block.
'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPPredicateParser'
  instVarNames: #( predicate predicateMessage negated
                    negatedMessage)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPPredicateParser
doit
PPPredicateParser comment: 
'An abstract parser that accepts if a given predicate holds.

Instance Variables:
	predicate	<BlockClosure>	The block testing for the predicate.
	predicateMessage	<String>	The error message of the predicate.
	negated	<BlockClosure>	The block testing for the negation of the predicate.
	negatedMessage	<String>	The error message of the negated predicate.'.
true
%

expectvalue %String
doit
(PPPredicateParser subclass: 'PPPredicateObjectParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPPredicateObjectParser
doit
PPPredicateObjectParser comment: 
'A parser that accepts if a given predicate on one element of the input sequence holds.'.
true
%

expectvalue %String
doit
(PPPredicateParser subclass: 'PPPredicateSequenceParser'
  instVarNames: #( size)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPPredicateSequenceParser
doit
PPPredicateSequenceParser comment: 
'A parser that accepts if a given predicate on an arbitrary number of elements of the input sequence holds.

Instance Variables:
	size	<Integer>	The number of elements to consume.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPUnresolvedParser'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPUnresolvedParser
doit
PPUnresolvedParser comment: 
'This is a temporary placeholder or forward reference to a parser that has not been defined yet. If everything goes well it will eventually be replaced with the real parser instance.'.
true
%

expectvalue %String
doit
(Object subclass: 'PPToken'
  instVarNames: #( newLineParser collection start stop value)
  classVars: #( )
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPToken
doit
PPToken comment: 
'PPToken represents a parsed part of the input stream. Contrary to a simple String it remembers where it came from, the original collection and its start and stop position.

Instance Variables:
	collection	<SequenceableCollection>	The collection this token comes from.
	start	<Integer>	The start position in the collection.
	stop	<Integer>	The stop position in the collection.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPStartOfLineParser'
  instVarNames: #( )
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPStartOfLineParser
doit
PPStartOfLineParser comment: 
'A PPStartOfLineParser is that does not fail, if the stream position is at the beginning of a line. It does not consume anything.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPStartOfLogicalLineParser'
  instVarNames: #( )
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPStartOfLogicalLineParser
doit
PPStartOfLogicalLineParser comment: 
'A PPStartOfLogicalLineParser is that does not fail, if the stream position is at the first non-blank character of a line. It does not consume anything.'.
true
%

expectvalue %String
doit
(PPParser subclass: 'PPStartOfWordParser'
  instVarNames: #( )
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
) definition.
%

expectvalue %Boolean

! ------------------- Class comment for PPStartOfWordParser
doit
PPStartOfWordParser comment: 
'A PPStartOfWordParser is that matches a word boundary.

I return success if no word character preceeds my position and if word chracter succeeds my position.

Word characters are any alphanumeric characters.'.
true
%

