!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   RcCollisionBucket, CollisionBucket, Array, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

! Create the class RcCollisionBucket, if it does not already exist

expectvalue %String
run
  CollisionBucket _newKernelSubclass: 'RcCollisionBucket'
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: { }
    inDictionary: Globals
      options: #()
    reservedOop: 897
%

removeallmethods RcCollisionBucket
removeallclassmethods RcCollisionBucket

category: 'For Documentation Installation only'
classmethod: RcCollisionBucket
installDocumentation

self comment: 
'The class RcCollisionBucket implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended for 
customer use, by creating instances or by subclassing.

 An RcCollisionBucket is a CollisionBucket that is used in an
 RcKeyValueDictionary to store a collection of key/value pairs for which the
 keys hash to the same value.  It provides support for the reduced-conflict
 properties of RcKeyValueDictionaries.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object
'
%

! ------------------- Class methods for RcCollisionBucket
! ------------------- Instance methods for RcCollisionBucket
category: 'Accessing'
method: RcCollisionBucket
keyAt: index

"Returns the key at the specified index."

^ self _rcAt: (index + index - 1)
%

category: 'Updating'
method: RcCollisionBucket
reset

"Reset all entries to nil and the number of elements to zero."

self _deleteNoShrinkFrom: 1 to: self _basicSize.
numElements := 0.
System _addEntireObjectToRcReadSet: self
%

category: 'Accessing'
method: RcCollisionBucket
valueAt: index

"Returns the value at the specified index."

^ self _rcAt: (index + index)
%

! uses _addNamedIvsToRcRead to fix 45054
category: 'Updating'
method: RcCollisionBucket
at: aKey put: aValue

"Stores the aKey/aValue pair in the RcCollisionBucket.  If the key already
 exists, returns the old value, otherwise, returns nil.  

 If the key already exists and the old value is identically aValue,
 does not write the receiver."

| emptySlotIndex startTableSize thisKey oldVal |
startTableSize := self tableSize .
aKey == nil
    ifTrue:[ ^ self _error: #rtErrNilKey ].

" search for aKey, or for the first empty slot "
1 to: startTableSize do: [ :index | | valIdx |
  valIdx := index + index .
  thisKey := self _at: (valIdx - 1) . "inline keyAt:"
  ( nil == emptySlotIndex and: [ nil == thisKey ] ) ifTrue:[ 
     emptySlotIndex := index 
  ] ifFalse: [
    (self compareKey: aKey with: thisKey) ifTrue:[
       "Key found.  Store given value"
	oldVal := self _at: valIdx .  "inline valueAt:"
	oldVal == aValue ifFalse:[
	  self _rcAt: valIdx  .  "put path to value slot in rcReadSet"
	  self at: index putValue: aValue. 
	].
	^ oldVal
     ]
  ]
] .

" key not found so add key and value"
emptySlotIndex == nil ifTrue:[ 
   " bucket is full so grow it "
   self size: (self _basicSize + 8 ) . "accommodate 4 more key,value pairs"
   emptySlotIndex := startTableSize + 1 .
] .
self _rcAt:( emptySlotIndex * 2) .  "put path to emptySlot in rcReadSet"
self _addNamedIvsToRcRead .  "for update of numElements"
numElements := numElements + 1.
self at: emptySlotIndex putKey: aKey.
self at: emptySlotIndex putValue: aValue.
^ nil
%

category: 'Private'
method: RcCollisionBucket
_addToWriteSet

"Make a benign modification to the receiver so that it is placed in 
 the write set."

numElements := numElements
%

