!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   RcQueueEntry, RcQueueElement, Object.
!
!=========================================================================

expectvalue %String
run
^RcQueueElement _newKernelSubclass: 'RcQueueEntry'
        instVarNames: #( 'createTimeUs' )
        classVars: #()
        classInstVars: #()
        poolDictionaries: { }
        inDictionary: Globals
        options: #()
        reservedOop: 975
%

removeallmethods RcQueueEntry
removeallclassmethods RcQueueEntry

category: 'For Documentation Installation only'
classmethod: RcQueueEntry
installDocumentation

self comment:
'RcQueueEntry describes an individual entry in a reduced-conflict queue.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.
Constraints:
	value: Object
	sequenceNumber: SmallInteger
	createTime: SmallInteger
	createTimeUs: SmallInteger
--- instVar createTime
A SmallInteger that represents a timestamp in gmt2005 format, indicating the time at which the
 RcQueue >> add: method was invoked to add this entry to the queue.
--- instVar createTimeUs
A SmallInteger that represents a microsecond timestamp, indicating the time at which the
 RcQueue >> add: method was invoked to add this entry to the queue.
--- instVar sequenceNumber
A SmallInteger that indicates this entry''s retrieval position.
--- instVar value
The object (any kind) stored in the queue.
'
%

category: 'Accessing'
method: RcQueueEntry
createTimeUs

"Returns the value of the entry's microsecond timestamp, the createTimeUs instance
 variable."

^createTimeUs
%

category: 'Updating'
method: RcQueueEntry
createTimeUs: newValue

"Modifies the value of the microsecond timestamp, the createTimeUs instance variable."

createTimeUs := newValue
%

category: 'Comparing'
method: RcQueueEntry
createTimeAsGmt95

"Return the create time in gmt95 format.  We add a constant to our
 create time, which is always in gmt2005 format."
^createTime + 315619200.
%

category: 'Comparing'
method: RcQueueEntry
createTimeAsGmt2005

"Return the create time in gmt2005 format, 
 which we always use for createTime."
^createTime
%

category: 'Comparing'
method: RcQueueEntry
isOlderThan: anotherElementOrEntry

"Compare the creation time of this object to that of anotherElementOrEntry,
 which must be an instance of RcQueueElement or RcQueueEntry object.  
 Answers true if this object is older than anotherElementOrEntry or 
 if anotherElementOrEntry is nil.   Answers false otherwise."

anotherElementOrEntry == nil
  ifTrue:[^true].

^(createTime == anotherElementOrEntry createTimeAsGmt2005)
  ifTrue:[createTimeUs < anotherElementOrEntry createTimeUs]
  ifFalse:[createTime < anotherElementOrEntry createTimeAsGmt2005].
%

category: 'Deprecated'
classmethod: RcQueueEntry
newWithValue: anObject 
sequenceNumber: aSmallInt 
inSegmentOf: parentObj

self deprecated: 'newWithValue:sequenceNumber:inSegmentOf: Deprecated before v3.2, use newWithValue:sequenceNumber:inObjectSecurityPolicyOf:'. 
	^self
		newWithValue: anObject 
		sequenceNumber: aSmallInt 
		inObjectSecurityPolicyOf: parentObj
%

category: 'Instance Creation'
classmethod: RcQueueEntry
newWithValue: anObject 
sequenceNumber: aSmallInt 
inObjectSecurityPolicyOf: parentObj
"Return a new instance of the receiver containing anObject as the value and
 aSmallInt as the sequence number.  This method also fills in the createTime
 and createTimeUs instance variables with the current time."

<primitive: 616>
aSmallInt _validateClass: SmallInteger .
^self _primitiveFailed: #newWithValue:sequenceNumber:inObjectSecurityPolicy: 
      args: { anObject . aSmallInt . parentObj } .
%

