!=========================================================================
! Copyright (C) GemTalk Systems 2005-2020.  All Rights Reserved.
! 
!  segmentorder_1xto22.gs - to be filed into Gemstone64 v1.x prior to
!	conversion of repository to Gemstone64 v2.2.x
!
!  fixes ordering of Segments in SystemRepository to agree with 64bit image
!
! $Id$
!
!=========================================================================

! must be logged in as SystemUser

classmethod: Segment
new
"temporary implementation for conversion"

| res |
res := super new .
res initialize .
^ res
%  
method: Segment
"temporary implementation for conversion"
initialize

  itsRepository := SystemRepository
%

expectvalue %String
run
"check naming in Globals of the segments with reserved oops"
| report namedSegBlk lf |
report := String new .
lf := Character lf .
namedSegBlk := [:aName :objId | | aSeg namedSeg |
  aSeg := Object _objectForOop: objId .
  aSeg == nil ifTrue:[
    report addAll: aName ; adAll: '  object ';
      addAll: objId asString ; addAll:' does not exist'; add: lf .
  ] ifFalse:[
    namedSeg := Globals at: aName otherwise: nil .
    report addAll: aName .
    namedSeg == aSeg ifTrue:[
      report addAll:' name ok '; add: lf .
    ] ifFalse:[
      namedSeg == nil ifTrue:[
        report addAll:' not in Globals, added'; add: lf .
      ] ifFalse:[
        report addAll:' wrong in Globals, changed value'; add: lf .
      ].
      Globals at: aName put: aSeg
    ].
  ].
]. 
namedSegBlk value: #SystemSegment      value: 1627 .
SystemRepository size > 1 ifTrue:[
  "Repository probably originated in 32bit v6.x  "
  namedSegBlk value: #DataCuratorSegment value: 1631 .
  namedSegBlk value: #SecurityDataSegment value: 1843 .
] ifFalse:[ | dcSeg aSeg |
  "Repository originated in 64bit v1.x "
  dcSeg := Object _objectForOop: 1631 .
  aSeg := Globals at: #DataCuratorSegment otherwise: nil  .
  aSeg == dcSeg ifFalse:[
    nil error:'invalid DataCuratorSegment' .
  ].
  dcSeg == nil ifTrue:[
    nil error:'nil DataCuratorSegment' .
  ].
  SystemRepository _basicAt:2 put: dcSeg .
  report addAll:'added DataCuratorSegment to SystemRepository'; add: lf .
].
^ report
%

! ensure default segments exist for GcUser and Nameless
expectvalue true
run
(AllUsers userWithId:'GcUser') defaultSegment class == Segment
%
expectvalue true
run
(AllUsers userWithId:'Nameless') defaultSegment class == Segment
%

expectvalue %String
run
| getSegBlk report lf 
  sysSeg dcSeg tzSeg idxSeg scdSeg pubSeg gcSeg namelessSeg 
  reposSegs firstSegs  identicalSegs  idx nonNilFirstSegs |
report := String new .
lf := Character lf .
reposSegs := Array withAll:SystemRepository .
report addAll:'starting Segment count ', reposSegs size asString ; add: lf .
getSegBlk := [:aName | |seg |
  seg := Globals at: aName otherwise: nil .
  seg == nil ifTrue:[ 
    report addAll:'Segment ', aName; addAll:' does not exist, creating'; add: lf .
    seg := Segment new .
    Globals at: aName put: seg .
  ]. 
  seg == sysSeg ifTrue:[  "repository originated on 64bit v1.x"
    report addAll:'Segment ', aName; addAll:' was aliased to SystemSegment, creating new'; add: lf .
    seg := Segment new .
    Globals at: aName put: seg .
  ].
  seg 
].
sysSeg := Globals at: #SystemSegment  .
dcSeg := Globals at:#DataCuratorSegment .
tzSeg := getSegBlk value:#GsTimeZoneSegment .
idxSeg := getSegBlk value:#GsIndexingSegment .
scdSeg := getSegBlk value:#SecurityDataSegment .
pubSeg := getSegBlk value:#PublishedSegment .
"ordering of firstSegs must match 64bit v2.2 image"
firstSegs := { sysSeg . dcSeg . tzSeg . idxSeg . scdSeg . pubSeg }. "gcSeg, namelessSeg"

gcSeg := (AllUsers userWithId:'GcUser') defaultSegment .
(firstSegs includesIdentical: gcSeg) ifTrue:[
  gcSeg := Segment new .
  report addAll:'created new Segment for GcUser'; add: lf .
].
firstSegs addLast: Segment new . 
namelessSeg := (AllUsers userWithId:'Nameless') defaultSegment .
(firstSegs includesIdentical: namelessSeg) ifTrue:[
  namelessSeg := Segment new .
  report addAll:'created new Segment for Nameless'; add: lf .
].
firstSegs addLast: namelessSeg .


identicalSegs := IdentitySet withAll: firstSegs .
nonNilFirstSegs := IdentitySet withAll: firstSegs .
identicalSegs size = nonNilFirstSegs size ifFalse:[
  nil error:'bad size,  ', identicalSegs size asString , ' ' , nonNilFirstSegs size asString.
].
SystemRepository _basicSize: 0 .
1 to: 2 do:[:j | |aSeg |
  aSeg := firstSegs at:j .
  (aSeg ~~ nil) ifTrue:[
    SystemRepository _basicAt:j put: aSeg .
    reposSegs removeIdentical: aSeg ifAbsent:[
      report addAll:'(firstSegs at: ', j asString , 
	  ') not in reposSegs, added at ', j asString ; add: lf .
    ] .
  ].
].
idx := 3 .
3 to: firstSegs size do:[:j | |aSeg |
  aSeg := firstSegs at: j .
  (aSeg ~~ nil and:[ aSeg ~~ dcSeg and:[aSeg ~~ sysSeg]]) ifTrue:[
    SystemRepository _basicAt: idx put: aSeg .
    reposSegs removeIdentical: aSeg ifAbsent:[
      report addAll:'(firstSegs at: ', j asString , 
	 ') not in reposSegs, added at ', idx asString; add: lf .
    ] .
    idx :=  idx + 1 .
  ].
].
1 to: reposSegs size do:[:k | |aSeg |
  aSeg := reposSegs at: k .
  aSeg ~~ nil ifTrue:[
    (identicalSegs includesIdentical: aSeg) ifFalse:[
      identicalSegs add: aSeg .
      SystemRepository _basicAt:idx put: aSeg .
      idx := idx + 1 
    ] ifTrue:[
      report addAll:'found a duplicate Segment'; add: lf .
    ].
  ].
].
report addAll:'ending Segment count ', SystemRepository size asString; add: lf .
^ report
%

level 1
expectvalue %Repository
obj SystemRepository
level 0

