#set -xv
#=========================================================================
# Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
#
# Name - gemsetup.sh
#
# Purpose - This is a POSIX-compliant shell "." file that explicitly defines
#	    your GemStone environment.
#
#	    It performs the following steps:
#
#	    a) It adds $GEMSTONE/bin to the end of your PATH.  This is "safe"
#	       in the sense that it will avoids breaking existing user commands
#	       and applications.  It is "unsafe" in the sense that an existing
#	       user command may silently supersede a GemStone-defined command,
#	       such as "topazl".
#
#           b) It adds $GEMSTONE/doc to the end of your MANPATH.  This will
#	       not work with Ultrix and DG/UX man commands, which are not
#	       POSIX compliant.
#
# Note that this script requires a GEMSTONE environment variable that points
# to a valid GemStone directory.
#
# $Id$
#
#=========================================================================

ok=1

# Set GEMSTONE environment variable
if [ "x$GEMSTONE" = "x" ]; then
    echo "gemsetup[Error]: Do not know the location of the GemStone files."
    echo "   Please set the GEMSTONE environment variable, and rerun this script."
    ok=0
else
# echo "gemsetup[Warning]:  Using default GEMSTONE $GEMSTONE"
  export GEMSTONE # just in case
fi

# Make test so that -d doesn't crash
if [ $ok -eq 1 ]; then
  if [ x$GEMSTONE = x ]; then
    echo "gemsetup[Error]:    GEMSTONE definition is empty"
    ok=0
  fi
fi

# Verify existence of directory
if [ $ok -eq 1 ]; then
  if [ ! -d $GEMSTONE ]; then
    echo "gemsetup[Error]:    directory GEMSTONE does not exist"
    echo "    GEMSTONE=$GEMSTONE"
    ok=0
  fi
fi

# Set path, manpath, etc.
if [ $ok -eq 1 ]; then
  export GEMSTONE
  gs_savepath=$PATH
  PATH=$GEMSTONE/bin:$PATH;    	     export PATH
  defaultManPath=/usr/man
  # bug 40199 - determine correct location for uname
  if [ -f "/bin/uname" ]; then
    UNAME="/bin/uname"
  elif [ -f "/usr/bin/uname" ]; then
    UNAME="/usr/bin/uname"
  else
  # Weird case.  Let's just hope it's in the path...
    UNAME="uname"
  fi
  gsuHOSTTYPE=`$UNAME -s`
  case "x$gsuHOSTTYPE" in
    xLinux) # Linux
      defaultManPath=
      ;;
    xDarwin) # Apple Darwin
      defaultManPath=
      ;;
    *)
      # for all other platforms..
      defaultManPath=/usr/share/man
      ;;
    esac
  if [ "x$MANPATH" = "x" ]; then
    MANPATH=${defaultManPath}:$GEMSTONE/doc
  else
    MANPATH=${MANPATH}:$GEMSTONE/doc
  fi
  unset defaultManPath
  export MANPATH
else
  echo "gemsetup[Warning]:  GemStone version setup aborted."
  ok=1
fi
