#! /bin/sh
#set -x
#=========================================================================
# Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
#
# Name - archivelogs.sh
#
#  Example shell script to illustrate use of copydbf and removedbf to
#  archive logs out of raw partitions to a file system.
#
#  This is provided as an example only and must be modified and tested
#  by the GemStone database administrator.
#
# $Id$
#
#=========================================================================

if [ "x$BASH_VERSION" = "x" ]; then
  if [ "a$GEMSTONE" = "a" ]; then
    echo "ERROR: GemStone scripts require a GEMSTONE environment variable."
    echo "       Please set it to the directory where GemStone resides."
    exit 1
  fi
  BASH=$GEMSTONE/bin/bash
  # Should be using -x here, but we have Ultrix /bin/sh to consider..
  if [ ! -f $BASH ]; then
    echo "ERROR: I can't find $BASH. Please check your GEMSTONE environment"
    echo "       variable, or call GemStone Customer Support for assistance."
    exit 1
  fi
  if [ ! -f /etc/license ]; then # don't do this with Ultrix shell
    unset ENV
  fi
  exec $BASH -norc -noprofile $0 $*
  exit $?
fi

# edit the following line to list the raw partitions used for transaction logs
logs="/dev/rsd2e /dev/rsd3h"

# edit the following line to specify a file system directory which is
#   the destination for copying the tranlogs
logArchive="./dbf/logs"

if [ -d $logArchive ]; then
  echo "[archive] using destination directory $logArchive"
else
  echo "[archive] ERROR, destination directory $logArchive "
  echo "             does not exist or is not a directory."
  exit 1
fi

for aLog in $logs; do
  echo ""
  echo "[archive] Opening log $aLog"
  $GEMSTONE/bin/copydbf $aLog -i
  status=$?
  if [ $status -ne 0 ]; then
    echo "[archive] unable to open log $aLog, file in use or does not exist"
  else
    echo "[archive] Copying log $aLog"
    $GEMSTONE/bin/copydbf $aLog $logArchive 
    status=$?
    if [ $status -ne 0 ]; then
      echo "[archive] ERROR, unable to archive log $aLog"
      exit 1
    else
      echo "[archive] Removing log $aLog"
      $GEMSTONE/bin/removedbf $aLog
      status=$?
      if [ $status -ne 0 ]; then
        echo "[archive] ERROR, unable to remove log $aLog after archiving"
        exit 1
      fi
    fi
  fi
done
exit 0
