!=========================================================================
! Copyright (C) GemTalk Systems 2017-2020.  All Rights Reserved.
!
! $Id: Btree-Comparison-Core.gs 38384 2016-01-08 18:22:36Z lalmarod $
!
! Btree-Comparison-Core.gs  -  source code for the gs comparison classes
!
!========================================================================

! class created in btreeplusclasses.gs

! Class Implementation for BtreeComparisonForIdentity

! Remove existing behavior from BtreeComparisonForIdentity
removeallmethods BtreeComparisonForIdentity
removeallclassmethods BtreeComparisonForIdentity

! ------------------- Class methods for BtreeComparisonForIdentity

category: 'Instance Creation'
classmethod: BtreeComparisonForIdentity
newForSort
  ^ self new
%

! ------------------- Instance methods for BtreeComparisonForIdentity

category: 'Comparison Operators'
method: BtreeComparisonForIdentity
compareKey: aKey equalTo: aValue
  ^ aKey == aValue
%

category: 'Comparison Operators'
method: BtreeComparisonForIdentity
compareKey: aKey greaterThan: aValue
  ^ aKey asOop > aValue asOop
%

category: 'Comparison Operators'
method: BtreeComparisonForIdentity
compareKey: aKey greaterThanOrEqualTo: aValue
  ^ aKey asOop >= aValue asOop
%

category: 'Comparison Operators'
method: BtreeComparisonForIdentity
compareKey: aKey lessThan: aValue
  ^ aKey asOop < aValue asOop
%

category: 'Comparison Operators'
method: BtreeComparisonForIdentity
compareKey: aKey lessThanOrEqualTo: aValue
  ^ aKey asOop <= aValue asOop
%

category: 'Testing'
method: BtreeComparisonForIdentity
satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2

  ^ ((val1 _idxForCompareGreaterThan: val2)
    or: [ (val1 _idxForSortEqualTo: val2) and: [ (bool1 and: [ bool2 ]) not ] ])
    not
%

! Class Implementation for BtreeOptimizedComparison

! Remove existing behavior from BtreeOptimizedComparison
removeallmethods BtreeOptimizedComparison
removeallclassmethods BtreeOptimizedComparison

! ------------------- Instance methods for BtreeOptimizedComparison

category: 'Comparison Operators'
method: BtreeOptimizedComparison
compareKey: aKey equalTo: aValue

^ aKey = aValue
%

category: 'Comparison Operators'
method: BtreeOptimizedComparison
compareKey: aKey greaterThan: aValue

^ aKey > aValue
%

category: 'Comparison Operators'
method: BtreeOptimizedComparison
compareKey: aKey greaterThanOrEqualTo: aValue

^ aKey >= aValue
%

category: 'Comparison Operators'
method: BtreeOptimizedComparison
compareKey: aKey lessThan: aValue

^ aKey < aValue
%

category: 'Comparison Operators'
method: BtreeOptimizedComparison
compareKey: aKey lessThanOrEqualTo: aValue

^ aKey <= aValue
%

category: 'Testing'
method: BtreeOptimizedComparison
satisfiableQueryGreaterThan: val1 
andEquals: bool1
andLessThan: val2 
andEquals: bool2

  "nil is a special case for optimized comparisons ... allowed in queries, but not as value in index"
  ^ val1 ifNil: [ true ]
    ifNotNil: [
      ((val1 > val2) or:
        [ (val1 = val2) and: [ (bool1 and:[bool2]) not ] ] ) not ]
%

! Class Extensions

! Class initializers 

doit
true.
%

category: 'initialization'
method: BtreeOptimizedUnicodeComparison
collator: anIcuCollator
  collator := anIcuCollator
%
category: 'Comparison Operators'
method: BtreeOptimizedUnicodeComparison
compareKey: aKey equalTo: aValue
  ^ aKey _equals: aValue collator: collator useMinSize: 900
%
category: 'Comparison Operators'
method: BtreeOptimizedUnicodeComparison
compareKey: aKey greaterThan: aValue
  ^ (aKey compareTo: aValue collator: collator useMinSize: 900) > 0
%
category: 'Comparison Operators'
method: BtreeOptimizedUnicodeComparison
compareKey: aKey greaterThanOrEqualTo: aValue
  ^ (self compareKey: aKey lessThan: aValue) not
%
category: 'Comparison Operators'
method: BtreeOptimizedUnicodeComparison
compareKey: aKey lessThan: aValue
  ^ (aKey compareTo: aValue collator: nil useMinSize: 900) < 0
%
category: 'Comparison Operators'
method: BtreeOptimizedUnicodeComparison
compareKey: aKey lessThanOrEqualTo: aValue
  ^ (self compareKey: aKey greaterThan: aValue) not
%
category: 'Testing'
method: BtreeOptimizedUnicodeComparison
satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2

  ^ (val1 isNil or: [ val2 isNil ])
    ifTrue: [
      ((val1 _idxForCompareGreaterThan: val2)
        or: [ (val1 _idxForCompareEqualTo: val2) and: [ (bool1 and: [ bool2 ]) not ] ]) not ]
    ifFalse: [ 
      ((self compareKey: val1 greaterThan: val2)
        or: [ 
          (self compareKey: val1 equalTo: val2)
            and: [ (bool1 and: [ bool2 ]) not ] ]) not ]
%
