!=========================================================================
! Copyright (C) GemTalk Systems 2017-2020.  All Rights Reserved.
!
! $Id: Btree-QuerySpec-Core.gs 38384 2016-01-08 18:22:36Z lalmarod $
!
! Btree-QuerySpec-Core.gs  -  source code for the gs query spec classes
!
!========================================================================

! class created in btreeplusclasses.gs

! Class Implementation for BtreePlusComparisonQuerySpec

! Remove existing behavior from BtreePlusComparisonQuerySpec
removeallmethods BtreePlusComparisonQuerySpec
removeallclassmethods BtreePlusComparisonQuerySpec

! ------------------- Class methods for BtreePlusComparisonQuerySpec

category: 'Instance Creation'
classmethod: BtreePlusComparisonQuerySpec
key: aKey selector: aSelector

^self new key: aKey selector: aSelector
%

! ------------------- Instance methods for BtreePlusComparisonQuerySpec

category: 'Querying'
method: BtreePlusComparisonQuerySpec
_addRootObjectsFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection
  (self optimizingComparison and: [ self canUseOptimizedComparison ])
    ifTrue: [ startIndex to: endIndex by: entrySize do: [ :i | collection add: (aLeafNode rootObjectAt: i) ] ]
    ifFalse: [ startIndex to: endIndex by: entrySize do: [ :i | (self compare: (aLeafNode keyAt: i) using: selector)
          ifTrue: [ collection add: (aLeafNode rootObjectAt: i) ] ] ]
%

category: 'Querying'
method: BtreePlusComparisonQuerySpec
_addValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection
  self shouldNotImplement: #'_addValuesFrom:entrySize:start:end:into:'
%

category: 'Querying'
method: BtreePlusComparisonQuerySpec
_traverseValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex previous: previousValue into: collection
  self shouldNotImplement: #'_traverseValuesFrom:entrySize:start:end:previous:into:'
%

category: 'Accessing'
method: BtreePlusComparisonQuerySpec
collator
  ^ nil
%

category: 'Accessing'
method: BtreePlusComparisonQuerySpec
collator: ignored
  "ignored"

  
%

category: 'Comparing'
method: BtreePlusComparisonQuerySpec
compare: entry using: sel
  ^ entry perform: sel with: key
%

category: 'Comparing'
method: BtreePlusComparisonQuerySpec
compareKey: entry
  ^ entry perform: selector with: key
%

category: 'Updating'
method: BtreePlusComparisonQuerySpec
key: aKey selector: aSelector
  key := aKey.
  self optimizingComparison
    ifTrue: [ selector := aSelector ]
    ifFalse: [ opCode := self operationSelectors indexOf: aSelector.
      selector := self performSelector: opCode ]
%

category: 'Accessing'
method: BtreePlusComparisonQuerySpec
operationSelectors

"Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation integer for each predicate entry in the receiver."

^ #( #< #> #= #== #<= #>= #~= #~~)
%

category: 'Accessing'
method: BtreePlusComparisonQuerySpec
optimizedUnicodeStringPerformSelectors
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the optimized operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'_idxForCompareEqualTo:collator:' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'_idxForCompareNotEqualTo:collator:' #'~~')
%

category: 'Accessing'
method: BtreePlusComparisonQuerySpec
optimizedUnicodeSymbolPerformSelectors
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the optimized operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'==' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'~~' #'~~')
%

category: 'Testing'
method: BtreePlusComparisonQuerySpec
optimizingComparison
  "Answer true if the receiver is optimizing comparisons"

  rangeIndex ifNil: [ ^ false ].
  ^ optimizingComparison
%

category: 'Accessing'
method: BtreePlusComparisonQuerySpec
performSelector: anOpCode

^self performSelectors at: anOpCode
%

category: 'Accessing'
method: BtreePlusComparisonQuerySpec
performSelectors

"Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

^ #( #_idxForCompareLessThan: 
    #_idxForCompareGreaterThan: 
    #_idxForCompareEqualTo:  
    #==
    #_idxForCompareLessThanOrEqualTo: 
    #_idxForCompareGreaterThanOrEqualTo: 
    #_idxForCompareNotEqualTo: 
    #~~
  )
%

category: 'Updating'
method: BtreePlusComparisonQuerySpec
rangeIndex: aGsRangeOrIdenityIndex
  "needed to know whether or not to optimize comparisons"

  rangeIndex := aGsRangeOrIdenityIndex.
  optimizingComparison := rangeIndex optimizingComparison
%

category: 'Accessing'
method: BtreePlusComparisonQuerySpec
unicodePerformSelector: anOpCode
  ^ rangeIndex constraintType == #'symbol'
      ifTrue: [ self optimizedUnicodeSymbolPerformSelectors at: anOpCode ]
      ifFalse: [ 
        rangeIndex constraintType == #'string'
          ifTrue: [ self optimizedUnicodeStringPerformSelectors at: anOpCode ]
          ifFalse: [ 
            "rangeIndex constraintType == #unicodeString or nil"
            self performSelector: anOpCode ] ]
%

! Class Implementation for BtreePlusRangeComparisonQuerySpec

! Remove existing behavior from BtreePlusRangeComparisonQuerySpec
removeallmethods BtreePlusRangeComparisonQuerySpec
removeallclassmethods BtreePlusRangeComparisonQuerySpec

! ------------------- Class methods for BtreePlusRangeComparisonQuerySpec

category: 'Instance Creation'
classmethod: BtreePlusRangeComparisonQuerySpec
key: aKey selector: aSelector and: aKey2 selector: aSelector2

| new |
new := self new key: aKey selector: aSelector.
new key2: aKey2 selector2: aSelector2.
^new
%

! ------------------- Instance methods for BtreePlusRangeComparisonQuerySpec

category: 'Updating'
method: BtreePlusRangeComparisonQuerySpec
_addRootObjectsFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection
   (self optimizingComparison and: [ self canUseOptimizedComparison ])
    ifTrue: [ startIndex to: endIndex by: entrySize do: [ :i | collection add: (aLeafNode rootObjectAt: i) ] ]
    ifFalse: [ startIndex to: endIndex by: entrySize do: [ :i | | aKey |
        aKey := aLeafNode keyAt: i.
        (self compare: aKey using: selector and: selector2)
          ifTrue: [ collection add: (aLeafNode rootObjectAt: i) ] ] ]
%

category: 'Comparing'
method: BtreePlusRangeComparisonQuerySpec
compare: entry using: sel1 and: sel2
  ^ (entry perform: sel1 with: key) and: [ entry perform: sel2 with: key2 ]
%

category: 'Comparing'
method: BtreePlusRangeComparisonQuerySpec
compareKey: entry
  ^ (entry perform: selector with: key)
    and: [ entry perform: selector2 with: key2 ]
%

category: 'Updating'
method: BtreePlusRangeComparisonQuerySpec
key2: aKey2 selector2: aSelector2
  key2 := aKey2.
  self optimizingComparison
    ifTrue: [ selector2 := aSelector2 ]
    ifFalse: [ opCode2 := self operationSelectors indexOf: aSelector2.
      selector2 := self performSelector: opCode2 ]
%

! Class Implementation for BtreePlusUnicodeRangeComparisonQuerySpec

! Remove existing behavior from BtreePlusUnicodeRangeComparisonQuerySpec
removeallmethods BtreePlusUnicodeRangeComparisonQuerySpec
removeallclassmethods BtreePlusUnicodeRangeComparisonQuerySpec

! ------------------- Instance methods for BtreePlusUnicodeRangeComparisonQuerySpec

category: 'Accessing'
method: BtreePlusUnicodeRangeComparisonQuerySpec
collator
  ^ collator
%

category: 'Accessing'
method: BtreePlusUnicodeRangeComparisonQuerySpec
collator: anIcuCollator
  collator :=  anIcuCollator
%

category: 'Comparing'
method: BtreePlusUnicodeRangeComparisonQuerySpec
compare: entry using: sel1 and: sel2
  ^ (entry perform: sel1 with: key with: self collator)
    and: [ entry perform: sel2 with: key2 with: self collator ]
%

category: 'Updating'
method: BtreePlusUnicodeRangeComparisonQuerySpec
key: aKey selector: aSelector
  key := aKey.
  opCode := self operationSelectors indexOf: aSelector.
  selector := self unicodePerformSelector: opCode
%

category: 'Updating'
method: BtreePlusUnicodeRangeComparisonQuerySpec
key2: aKey2 selector2: aSelector2
  key2 := aKey2.
  opCode2 := self operationSelectors indexOf: aSelector2.
  selector2 := self unicodePerformSelector: opCode2
%

category: 'Accessing'
method: BtreePlusUnicodeRangeComparisonQuerySpec
performSelectors
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'_idxForCompareEqualTo:collator:' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'_idxForCompareNotEqualTo:collator:' #'~~')
%

! Class Implementation for BtreePlusUnicodeComparisonQuerySpec

! Remove existing behavior from BtreePlusUnicodeComparisonQuerySpec
removeallmethods BtreePlusUnicodeComparisonQuerySpec
removeallclassmethods BtreePlusUnicodeComparisonQuerySpec

! ------------------- Instance methods for BtreePlusUnicodeComparisonQuerySpec

category: 'Accessing'
method: BtreePlusUnicodeComparisonQuerySpec
collator
  ^ collator
%

category: 'Accessing'
method: BtreePlusUnicodeComparisonQuerySpec
collator: anIcuCollator
  collator :=  anIcuCollator
%

category: 'Comparing'
method: BtreePlusUnicodeComparisonQuerySpec
compare: entry using: sel
  ^ sel numArgs == 1
    ifTrue: [ entry perform: sel with: key ]
    ifFalse: [ entry perform: sel with: key with: self collator ]
%

category: 'Comparing'
method: BtreePlusUnicodeComparisonQuerySpec
compareKey: entry
  ^ selector numArgs == 1
    ifTrue: [ entry perform: selector with: key ]
    ifFalse: [ entry perform: selector with: key with: self collator ]
%

category: 'Updating'
method: BtreePlusUnicodeComparisonQuerySpec
key: aKey selector: aSelector
  key := aKey.
  opCode := self operationSelectors indexOf: aSelector.
  selector := self unicodePerformSelector: opCode
%

category: 'Accessing'
method: BtreePlusUnicodeComparisonQuerySpec
performSelectors
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'_idxForCompareEqualTo:collator:' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'_idxForCompareNotEqualTo:collator:' #'~~')
%

! Class Extensions

! Class initializers 

doit
true.
%

category: 'Testing'
method: BtreePlusComparisonQuerySpec
canUseOptimizedComparison

  ^ #( #< #> #= #<= #>= ) includes: selector
%
