!=========================================================================
! Copyright (C) GemTalk Systems 2008-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   GsFileStat, Object.
!
!=========================================================================

! Remove existing behavior 
removeallmethods GsFileStat
removeallclassmethods GsFileStat

set class GsFileStat

! ------------------- Class methods for GsFileStat
category: 'Documentation'
classmethod: 
comment
^ '
An instance of GsFileStat contains the results of an operating system fstat()
call for an instance of GsFile.  

The instance variables are as follows, all values should be SmallIntegers.
Values of type time_t are in seconds since 00:00:00 UTC, Jan. 1, 1970 .
     atime      time_t of last access 
     blksize    perferred IO block size in bytes
     blocks     number of 512 byte blocks allocated for the file
     ctime      time_t of last file status change
     dev        ID of device containing directory entry for the file
     gid        Group ID of file''s group
     ino        Inode number
     mode       Filemode (see mknod(2)
     mtime      time_t of last data modification
     nlink      Number of links
     rdev       ID of device (only valid for char special or block special files)
     size       File size in bytes
     uid        User ID of the file''s owner

See class GsFile for methods which return instances of GsFileStat.
Instances of GsFileStat represent the state of a GsFile at the point
when the instance of GsFileStat  was created and do not reflect subsequent
changes to the underlying file.

Constraints:
	atime: SmallInteger
	blksize: SmallInteger
	blocks: SmallInteger
	ctime: SmallInteger
	dev: SmallInteger
	gid: SmallInteger
	ino: SmallInteger
	mode: SmallInteger
	mtime: SmallInteger
	nlink: SmallInteger
	rdev: SmallInteger
	size: SmallInteger
	uid: SmallInteger
'
%

category: 'Instance Creation'
classmethod:
new

"Disallowed.  
  see instance methods in GsFile for methods returning instances of GsFileStat"

  self shouldNotImplement: #new
%


! ------------------- Instance methods for GsFileStat
category: 'Accessing'

method:
atimeUtcSeconds
^  atime 
%
method:
blksize
^ blksize
%
method:
blocks
^  blocks
%
method:
ctimeUtcSeconds
^  ctime
%
method:
dev
^  dev
%
method:
gid
^  gid
%
method:
ino
^  ino
%
method:
mode
^  mode
%
method:
mtimeUtcSeconds
^  mtime
%
method:
nlink
^  nlink
%
method:
rdev
^  rdev
%
method:
size
^  size
%
method:
uid
^  uid
%
method:
isDirectory
 "Returns true if the receiver describes a directory."
  ^ ( mode bitAnd: 8r170000 "posix S_IFMT") == 8r40000 "posix S_IFDIR"
%
  


