! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! $Id$
!
! ========================================================================

expectvalue %String
run
^ GsTlsCredential _newKernelSubclass: #GsTlsPublicKey
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #()
  reservedOop: nil
%

doit
GsTlsPublicKey category: 'X509'.
true
%

! Remove existing behavior from GsTlsPublicKey
removeallmethods GsTlsPublicKey
removeallclassmethods GsTlsPublicKey

! ------------------- Class methods for GsTlsPublicKey
classmethod:
comment
^'GsTlsPublicKey encapsulates a TLS/SSL public key.'
%

category: 'Instance Creation'
classmethod:
newFromPemFile: fileNameString
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. If the PEM file contains multiple keys, only the
 first is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver."
 
^ self tls3ArgPrim: 0 with: fileNameString with: nil with: 2
%

category: 'Instance Creation'
classmethod:
newFromPemString: aPemString
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple keys, only the first is read. 

 Raises an exception if the string is not in PEM format or if the type of
 object in the PEM string does not match the receiver."
 
^ self tls3ArgPrim: 1 with: aPemString with: nil with: 2
%

category: 'Testing'
method:
isPrivateKey
 ^ false
%
category: 'Testing'
method:
isPublicKey
 ^ true
%
category: 'Testing'
method:
isX509Certificate
 ^ false
%

category: 'Instance Creation'
classmethod:
fromCertificate: aGsX509Certificate

"Extract the public key from the argument and return a new instance of the
 receiver."

^ self tls3ArgPrim: 4  with: aGsX509Certificate with: nil with: 2
%

category: 'Converting'
method:
asPublicKey
 ^ self
%

category: 'Testing'
method:
canVerifyDigitalSignatures
^ self supportsDigitalSignatures
%

category: 'Testing'
method:
canCreateDigitalSignatures
"Only private keys may be used to create signatures."
^ false
%
category: 'Private'
method:
_validateIsRsaPss
^ self sslAlgorithm == #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: expected an RSS_PSS public key']
%
category: 'Private'
method:
_validateIsNotRsaPss
^ self sslAlgorithm ~~ #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: illegal RSS_PSS public key']
%

