!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! File  HostAgent.gs
!
! Description - UserProfile for the hostagent main program
!=========================================================================

set user SystemUser pass swordfish
login

expectvalue /String
run
| up res assoc |
up := AllUsers userWithId: 'HostAgentUser' ifAbsent:[ nil ].
up ifNil:[ 
  up := AllUsers addNewUserWithId:'HostAgentUser'
                         password: 'swordfish' 
                         createNewSecurityPolicy: true .
  Globals at: #HostAgentUserObjectSecurityPolicy put: (up defaultObjectSecurityPolicy) .
  res := 'created'.
] ifNotNil:[
  res := 'exists'.
].
up addPrivilege: 'SessionAccess' .
^ res
%
expectvalue /String
run
| up uG assoc |
up := AllUsers userWithId: 'HostAgentUser' .
assoc := Globals associationAt: #CodeLibrarian ifAbsent:[ ^ 'not found' ].
Globals removeAssociation: assoc .
uG := (up resolveSymbol: #UserGlobals) value .
uG addAssociation: assoc .
^ 'moved'
%

expectvalue /String
run
| up uG assoc |
up := AllUsers userWithId: 'HostAgentUser' .
uG := (up resolveSymbol: #UserGlobals) value .
(uG at: #AcceptTimeoutMs otherwise: nil) ifNil:[
  uG at: #AcceptTimeoutMs put: 5000 .
  ^ 'added'
].
'not changed'
%


expectvalue /String
run
| hau clibu assoc uG |
hau := AllUsers userWithId: 'HostAgentUser' .
clibu := AllUsers userWithId: 'CodeLibrarianUser' .
(clibu resolveSymbol: #CodeLibrarian) ifNil:[
  assoc := hau resolveSymbol: #CodeLibrarian ifNil:[ Error signal:'not found A'].
  uG := (clibu resolveSymbol: #UserGlobals) value .
  uG addAssociation: assoc .
  ^'added'
].
^ 'no change'
%


commit

expectvalue /String
run
 | key |
 key := #ObjectFiltersSecurityPolicy .
 "create ObjectFiltersSecurityPolicy , needed for X509 object filters"
 Globals at: key ifAbsent:[ | p |
   (p := GsObjectSecurityPolicy new)
     owner: (AllUsers userWithId:'DataCurator') ;
     worldAuthorization: #read ;
     ownerAuthorization: #write ;
     group: 'DataCuratorGroup' authorization: #write ;
     name: key asString .
   Globals at: key put: p . 
   ^ 'created ', key asString
 ].
 (Globals at: #ObjectFiltersSecurityPolicy) _validateInstanceOf: GsObjectSecurityPolicy .
 ^  key asString, ' exists'
%
commit

! load the X509 packages using CodeLibrarian
run
| clibu librarian |
clibu := AllUsers userWithId: 'CodeLibrarianUser' .
librarian := (clibu resolveSymbol: #CodeLibrarian) value.
librarian new
  user: 'SystemUser';
  symbolDictName: 'Globals' ;
  repository: 'tonel:$upgradeDir/packages/';
  load: #('X509-Core').
System commit
%

expectvalue /String
run
"create ObjectFilter association in HostAgentUser's UserGlobals"
| up assoc map seg dict |
assoc := (up := AllUsers userWithId:'HostAgentUser') resolveSymbol: #ObjectFilter .
assoc ifNil:[
  (assoc := SymbolAssociation new) key: #ObjectFilter .
  map := ObjectFilteringPolicyMap new  .
  seg := Globals at: #DataCuratorObjectSecurityPolicy .
  assoc objectSecurityPolicy: seg .
  map   objectSecurityPolicy: seg .
  (map policyForIP: '0.0.0.0') objectSecurityPolicy: seg .
  dict := (up resolveSymbol: #UserGlobals) value .
  dict addAssociation: assoc .
  map installObjectFilter .
  assoc value == map ifFalse:[ Error signal:'installObjectFilter failed' ].
  ^ 'Added ObjectFilter'.
].
^ 'no change'
%

run
| clibu librarian |
clibu := AllUsers userWithId: 'CodeLibrarianUser' .
librarian := (clibu resolveSymbol: #CodeLibrarian) value.
librarian new
  user: 'HostAgentUser';
  "default is to UserGlobals" 
  repository: 'tonel:$upgradeDir/packages/';
  load: #('X509-HostAgent').
System commit
%

logout
