!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   ProfMonitorEntry, Object.
!
!=========================================================================

expectvalue %String
run
| oldClass expectedInstVars newClass |
expectedInstVars := #(cmethod cclass tally parents
                    children total rcvrClass recursed root
                    childTallies parentTallies ).
oldClass := Globals at: #ProfMonitorEntry otherwise: nil.
(oldClass ~~ nil and: [oldClass instVarNames = expectedInstVars]) ifTrue: [
	^'Found expected class'.
].
newClass := Object 
  subclass: 'ProfMonitorEntry'
  instVarNames: expectedInstVars
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals .
^(oldClass ifNil: ['Created new class:'] 
	ifNotNil: ['Replaced old class with:']) , '
' , newClass definition.

%

! remove existing behavior from ProfMonitorEntry
removeallmethods ProfMonitorEntry
removeallclassmethods ProfMonitorEntry
set class ProfMonitorEntry

! ------------------- Class methods for ProfMonitorEntry
category: 'Documentation'
classmethod:
comment
^'
 A ProfMonitorEntry represents a stack frame from one or more samples
 taken by a ProfMonitor instance.'
%
category: 'Instance Creation'
classmethod: ProfMonitorEntry
new

  | pme |
  pme := self _basicNew.
  pme initialize.
  ^ pme
%

category: 'Instance Creation'
classmethod: ProfMonitorEntry
newForClass: aClass method: aMethod receiverClass: rcvrClass

  | pme |
  pme := self new.
  pme cclass: aClass.
  pme cmethod: aMethod.
  pme rcvrClass: rcvrClass.
  ^pme.
%

category: 'Instance Creation'
classmethod: ProfMonitorEntry
newForMethod: aMethod receiverClass: rcvrClass

  ^ self newForClass: nil method: aMethod receiverClass: rcvrClass
%

category: 'Instance Creation'
classmethod: ProfMonitorEntry
newForClass: aClass receiverClass: rcvrClass

  ^ self newForClass: aClass method: nil receiverClass: rcvrClass
%

! ------------------- Instance methods for ProfMonitorEntry
category: 'Initialization'
method:
initialize

  tally := 0.
  total :=  0.
  childTallies := IdentityDictionary new.
  parentTallies := IdentityDictionary new.
  children := IdentitySet new.
  parents := IdentitySet new.
  recursed := false.
%

category: 'Accessing'
method: 
children

   "Return the value of the instance variable 'children'."
   ^children
%
category: 'Accessing'
method: 
childTallies

   "Return the value of the instance variable 'childTallies'."
   ^childTallies
%
category: 'Accessing'
method: 
cmethod

   "Return the value of the instance variable 'cmethod'."
   ^cmethod
%
category: 'Accessing'
method: 
cclass

   "Return the value of the instance variable 'cclass'."
   ^cclass
%
category: 'Updating'
method: 
cmethod: newValue

   "Modify the value of the instance variable 'cmethod'."
   cmethod := newValue
%
category: 'Updating'
method: 
cclass: newValue

   "Modify the value of the instance variable 'cclass'."
   cclass := newValue
%
category: 'Accessing'
method: 
parents

   "Return the value of the instance variable 'parents'."
   ^parents
%
category: 'Accessing'
method: 
parentTallies

   "Return the value of the instance variable 'parentTallies'."
   ^parentTallies
%
category: 'Accessing'
method: 
rcvrClass

   "Return the value of the instance variable 'rcvrClass'."
   ^rcvrClass
%
category: 'Updating'
method: 
rcvrClass: newValue

   "Modify the value of the instance variable 'rcvrClass'."
   rcvrClass := newValue
%
category: 'Accessing'
method: 
recursed

   "Return the value of the instance variable 'recursed'."
   ^recursed
%
category: 'Updating'
method: 
recursed: newValue

   "Modify the value of the instance variable 'recursed'."
   recursed := newValue
%
category: 'Accessing'
method: 
root

   "Return the value of the instance variable 'root'."
   ^root
%
category: 'Updating'
method: 
root: newValue

   "Modify the value of the instance variable 'root'."
   root := newValue
%
category: 'Accessing'
method: 
tally

   "Return the value of the instance variable 'tally'."
   ^tally
%
category: 'Updating'
method: 
tally: newValue

   "Modify the value of the instance variable 'tally'."
   tally := newValue
%
category: 'Accessing'
method: 
total

   "Return the value of the instance variable 'total'."
   ^total
%
category: 'Updating'
method: 
total: newValue

   "Modify the value of the instance variable 'total'."
   total := newValue
%

category: 'Reporting'

! reimplemented in Maglev.mcz 
method:
asStringWidth: nameWidth
  | str mth |
  mth := cmethod .
  mth == #GCI ifTrue:[
    str := #GCI asString width: nameWidth .
  ] ifFalse:[ | rcvCls |
    str := mth _classAndSelectorNameWidth: nameWidth .  
    (mth inClass ~~ (rcvCls := rcvrClass) and:[ rcvCls ~~ Object]) ifTrue:[
      str add: ' [' ; add: rcvCls name ; add: ']' .
    ].
  ].
  ^ str
%

category: 'Updating'
method:
incrementTally: anInt

  tally := tally + anInt .
  total := total + anInt .
%
category: 'Updating'
method:
incrementTotal: anInt

  total := total + anInt .
%
