! SUnit.gs - port of SUnit-NiallRoss.40.mcz to GemStone from ESUG 2010
!

! If TestAsserter class does not exist, then make the following classes obsolete 
!   during conversion from 2.x. See bug42188.
expectvalue true
run
| names |
 (Globals at: #'TestAsserter' otherwise: nil) ifNotNil: [ ^true ].
 "TestAsserter does not exist, must be an upgrade, make the classes obsolete"
 names := {
    'TestCase'.
    'TestResource'.
    'ExampleSetTest'.
    'ResumableTestFailureTestCase'.
    'SimpleTestResourceTestCase'.
    'SUnitTest' }.
 names do: [:aName |
   (Symbol _existingWithAll: aName) ifNotNil: [:aSym | 
     (Globals at: aSym otherwise: nil) ifNotNil: [:aCls |
       aCls _makeClassObsolete: Globals.
     ].
   ].
 ].
true
%

! SUnitDelay
expectvalue %String
run
(Delay 
  subclass: 'SUnitDelay'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SUnitDelay category: 'SUnit-Preload'.
true
%

! SUnitNameResolver
expectvalue %String
run
(Object 
  subclass: 'SUnitNameResolver'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SUnitNameResolver category: 'SUnit-Preload'.
true
%

! TestAsserter
expectvalue %String
run
(Object 
  subclass: 'TestAsserter'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
TestAsserter category: 'SUnit-Kernel'.
true
%

! TestCase
expectvalue %String
run
(TestAsserter 
  subclass: 'TestCase'
  instVarNames: #(testSelector)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
TestCase category: 'SUnit-Kernel'.
true
%

! ExampleSetTest
expectvalue %String
run
(TestCase 
  subclass: 'ExampleSetTest'
  instVarNames: #(full empty)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
ExampleSetTest category: 'SUnit-Tests'.
true
%

! ResumableTestFailureTestCase
expectvalue %String
run
(TestCase 
  subclass: 'ResumableTestFailureTestCase'
  instVarNames: #(duplicateFailureLog)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
ResumableTestFailureTestCase category: 'SUnit-Tests'.
true
%

! SimpleTestResourceTestCase
expectvalue %String
run
(TestCase 
  subclass: 'SimpleTestResourceTestCase'
  instVarNames: #(resource)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SimpleTestResourceTestCase category: 'SUnit-Tests'.
true
%

! FailingTestResourceTestCase
expectvalue %String
run
(SimpleTestResourceTestCase 
  subclass: 'FailingTestResourceTestCase'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation )  )definition
%
run
FailingTestResourceTestCase category: 'SUnit-Tests'.
true
%

! ManyTestResourceTestCase
expectvalue %String
run
(SimpleTestResourceTestCase 
  subclass: 'ManyTestResourceTestCase'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
ManyTestResourceTestCase category: 'SUnit-Tests'.
true
%

! CircularTestResourceTestCase
expectvalue %String
run
(ManyTestResourceTestCase 
  subclass: 'CircularTestResourceTestCase'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
CircularTestResourceTestCase category: 'SUnit-Tests'.
true
%

! SUnitTest
expectvalue %String
run
(TestCase 
  subclass: 'SUnitTest'
  instVarNames: #(hasRun hasSetup hasRanOnce)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SUnitTest category: 'SUnit-Tests'.
true
%

! TestResource
expectvalue %String
run
(TestAsserter 
  subclass: 'TestResource'
  instVarNames: #(name description)
  classVars: #()
  classInstVars: #( "current" )
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
TestResource category: 'SUnit-Kernel'.
true
%

! SimpleTestResource
expectvalue %String
run
(TestResource 
  subclass: 'SimpleTestResource'
  instVarNames: #(runningState hasRun hasSetup)
  classVars: #()
  classInstVars: #( "preventAvailability" )
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%

expectvalue %String
run
| curr n |
n := 0 .   "remove old methods for fix 44744"
(curr := SimpleTestResource) classHistory size > 1 ifTrue:[
  curr classHistory do:[:cls |
    cls ~~ curr ifTrue:[ 
      cls removeAllMethods . cls class removeAllMethods .
      n := n + 1
    ].
  ].
].
^ 'found ', n asString , ' old versions'
%

run
SimpleTestResource category: 'SUnit-Tests'.
true
%

! SimpleTestResourceA
expectvalue %String
run
(SimpleTestResource 
  subclass: 'SimpleTestResourceA'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SimpleTestResourceA category: 'SUnit-Tests'.
true
%

! SimpleTestResourceA1
expectvalue %String
run
(SimpleTestResource 
  subclass: 'SimpleTestResourceA1'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SimpleTestResourceA1 category: 'SUnit-Tests'.
true
%

! SimpleTestResourceA2
expectvalue %String
run
(SimpleTestResource 
  subclass: 'SimpleTestResourceA2'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SimpleTestResourceA2 category: 'SUnit-Tests'.
true
%

! SimpleTestResourceB
expectvalue %String
run
(SimpleTestResource 
  subclass: 'SimpleTestResourceB'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SimpleTestResourceB category: 'SUnit-Tests'.
true
%

! SimpleTestResourceB1
expectvalue %String
run
(SimpleTestResource 
  subclass: 'SimpleTestResourceB1'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SimpleTestResourceB1 category: 'SUnit-Tests'.
true
%

! SimpleTestResourceCircular
expectvalue %String
run
(SimpleTestResource 
  subclass: 'SimpleTestResourceCircular'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SimpleTestResourceCircular category: 'SUnit-Tests'.
true
%

! SimpleTestResourceCircular1
expectvalue %String
run
(SimpleTestResource 
  subclass: 'SimpleTestResourceCircular1'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
SimpleTestResourceCircular1 category: 'SUnit-Tests'.
true
%

! TestFailure
expectvalue %String
run
(Exception 
  subclass: 'TestFailure'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
TestFailure category: 'SUnit-Preload'.
true
%

! ResumableTestFailure
expectvalue %String
run
(TestFailure 
  subclass: 'ResumableTestFailure'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
ResumableTestFailure category: 'SUnit-Preload'.
true
%

! TestResult
expectvalue %String
run
(Object 
  subclass: 'TestResult'
  instVarNames: #(failures errors passed)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
TestResult category: 'SUnit-Kernel'.
true
%

! TestSuite
expectvalue %String
run
(Object 
  subclass: 'TestSuite'
  instVarNames: #(tests resources name)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( #logCreation ) ) definition
%
run
TestSuite category: 'SUnit-Kernel'.
true
%

errorCount

! - *** - CircularTestResourceTestCase
removeAllClassMethods CircularTestResourceTestCase
removeAllMethods CircularTestResourceTestCase
category: 'Documentation'
classMethod: CircularTestResourceTestCase
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'accessing'
classMethod: CircularTestResourceTestCase
resources
	^super resources, { SimpleTestResourceCircular } 
%
category: 'utility'
method: CircularTestResourceTestCase
clearOuterResourceStateDuring: aBlock
	"To let the test run at all, we only make it circular when the preventAvailability instvar is set."

	^super clearOuterResourceStateDuring:
		[SimpleTestResourceCircular reset.
		self deny: SimpleTestResourceCircular1 isAlreadyAvailable
			description: 'SimpleTestResourceCircular1 should never be available'.
		SimpleTestResourceCircular preventAvailabilityDuring:
			[self should: aBlock raise: TestResult failure].
		self deny: SimpleTestResourceCircular isAlreadyAvailable
			description: 'SimpleTestResourceCircular was set up despite having circularity set'].
%
category: 'running'
method: CircularTestResourceTestCase
testTearDownOrder
	SimpleTestResourceCircular preventAvailabilityDuring:
		[self should: [SimpleTestResourceCircular reset; isAvailable] raise: TestResult failure.
		self assert: SimpleTestResourceCircular rawCurrentForTest == false
			description: 'Circular resource not in failed setUp state'.
		self assert: SimpleTestResourceCircular1 rawCurrentForTest == false
			description: 'Circular resource not in failed setUp state'.
		super testTearDownOrder.
		self assert: SimpleTestResourceCircular1 rawCurrentForTest == nil
			description: 'Circular resource not in failed setUp state'.
		self assert: SimpleTestResourceCircular rawCurrentForTest == nil
			description: 'Circular resource not reset after pre-tearDown iteration'].
%

errorCount

! - *** - ExampleSetTest
removeAllClassMethods ExampleSetTest
removeAllMethods ExampleSetTest
category: 'Documentation'
classMethod: ExampleSetTest
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'running'
method: ExampleSetTest
setUp
	empty := Set new.
	full := Set with: 5 with: #abc
%
category: 'testing'
method: ExampleSetTest
testAdd
	empty add: 5.
	self assert: (empty includes: 5)
%
category: 'testing'
method: ExampleSetTest
testGrow
	empty addAll: (1 to: 100).
	self assert: empty size = 100
%
category: 'testing'
method: ExampleSetTest
testIllegal
	self 
		should: [empty at: 5] 
		raise: TestResult error.
	self 
		should: [empty at: 5 put: #abc] 
		raise: TestResult error
%
category: 'testing'
method: ExampleSetTest
testIncludes
	self assert: (full includes: 5).
	self assert: (full includes: #abc)
%
category: 'testing'
method: ExampleSetTest
testOccurrences
	self assert: (empty occurrencesOf: 0) = 0.
	self assert: (full occurrencesOf: 5) = 1.
	full add: 5.
	self assert: (full occurrencesOf: 5) = 1
%
category: 'testing'
method: ExampleSetTest
testRemove
	full remove: 5.
	self assert: (full includes: #abc).
	self deny: (full includes: 5)
%

errorCount

! - *** - FailingTestResourceTestCase
removeAllClassMethods FailingTestResourceTestCase
removeAllMethods FailingTestResourceTestCase
category: 'Documentation'
classMethod: FailingTestResourceTestCase
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'utility'
method: FailingTestResourceTestCase
clearOuterResourceStateDuring: aBlock
	"Make the resource impossible to make available, then ensure that every test raises a failure but not an error (which its setUp would do if it reached it and the resource were nil)."

	^super clearOuterResourceStateDuring:
		[SimpleTestResource preventAvailabilityDuring:
			[self should: aBlock raise: TestResult failure]]
%

errorCount

! - *** - ManyTestResourceTestCase
removeAllClassMethods ManyTestResourceTestCase
removeAllMethods ManyTestResourceTestCase
category: 'Documentation'
classMethod: ManyTestResourceTestCase
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'accessing'
classMethod: ManyTestResourceTestCase
resources
	^super resources, { SimpleTestResourceA . SimpleTestResourceB }
%
category: 'testing'
classMethod: ManyTestResourceTestCase
shouldInheritSelectors
	^true
%
category: 'utility'
method: ManyTestResourceTestCase
clearOuterResourceStateDuring: aBlock
	"This self-testing test must clear the outer state of its resources before starting and after finishing, so that it can construct test cases and suites of itself and test them."

	self assert: SimpleTestResourceA1 isAlreadyAvailable
		description: 'The resource was not set up for the test'.
	SimpleTestResourceA reset.
	SimpleTestResourceB reset.
	SimpleTestResourceA1 reset.
	self deny: SimpleTestResourceA1 isAlreadyAvailable
		description: 'The resource was still set up before we began the run'.
	^[super clearOuterResourceStateDuring: aBlock] sunitEnsure:
		[self deny: SimpleTestResourceA1 isAlreadyAvailable
			description: 'The resource was still set up after we finished the run'.
		self deny: SimpleTestResourceB1 isAlreadyAvailable
			description: 'The resource was still set up after we finished the run'.
		SimpleTestResourceA isAvailable.
		self assert: SimpleTestResourceA1 isAlreadyAvailable
			description: 'The resource was not set up again after the test'.
		SimpleTestResourceB isAvailable.
		self assert: SimpleTestResourceB1 isAlreadyAvailable
			description: 'The resource was not set up again after the test'.].
%
category: 'running'
method: ManyTestResourceTestCase
testTearDownOrder
	| myResourceSetUpOrder myResourceReverseTearDownOrder |
	myResourceReverseTearDownOrder := OrderedCollection new: 7.
	myResourceSetUpOrder := (OrderedCollection new: 7)
		add: SimpleTestResource;
		add: SimpleTestResourceA1;
		add: SimpleTestResourceA2;
		add: SimpleTestResourceA;
		add: SimpleTestResourceB1;
		add: SimpleTestResourceB;
		yourself.
	self assert: (myResourceSetUpOrder allSatisfy: [:each | each isAvailable])
		description: 'At test start, not all my resources were set up'.
	self class resources do:
		[:each | each resetOrAddResourcesTo: myResourceReverseTearDownOrder].
	self assert: myResourceReverseTearDownOrder = myResourceSetUpOrder
		description: 'Wrong order for tearDown'.
	self assert: (myResourceSetUpOrder allSatisfy: [:each | each isAvailable])
		description: 'At test start, not all my resources were set up'.
%

errorCount

! - *** - ResumableTestFailure
removeAllClassMethods ResumableTestFailure
removeAllMethods ResumableTestFailure
category: 'Documentation'
classMethod: ResumableTestFailure
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'SUnit'
method: ResumableTestFailure
isResumable
	"Of course a ResumableTestFailure is resumable ;-)"

	^true
%
category: 'SUnit'
method: ResumableTestFailure
sunitExitWith: aValue
	self resume: aValue
%
category: 'Instance initialization'
method: ResumableTestFailure
initialize
  gsNumber := ERR_ResumableTestFailure .
  gsResumable := true .
  gsTrappable := true .
%


errorCount

! - *** - ResumableTestFailureTestCase
removeAllClassMethods ResumableTestFailureTestCase
removeAllMethods ResumableTestFailureTestCase
category: 'Documentation'
classMethod: ResumableTestFailureTestCase
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'test data'
method: ResumableTestFailureTestCase
errorTest
	1 zork
%
category: 'test data'
method: ResumableTestFailureTestCase
failureTest
	self
		assert: false description: 'You should see me' resumable: true; 
		assert: false description: 'You should see me too' resumable: true; 
		assert: false description: 'You should see me last' resumable: false; 
		assert: false description: 'You should not see me' resumable: true
%
category: 'logging'
method: ResumableTestFailureTestCase
logFailure: aString
	duplicateFailureLog add: aString.
	super logFailure: aString.
%
category: 'test data'
method: ResumableTestFailureTestCase
okTest
	self assert: true
%
category: 'test data'
method: ResumableTestFailureTestCase
regularTestFailureTest
	self assert: false description: 'You should see me'
%
category: 'running'
method: ResumableTestFailureTestCase
resumableTestFailureTest
	self
		assert: false description: 'You should see more than me' resumable: true; 
		assert: false description: 'You should see more than me' resumable: true; 
		assert: false description: 'You should see me last' resumable: false; 
		assert: false description: 'You should not see me' resumable: true
%
category: 'running'
method: ResumableTestFailureTestCase
setUp
	duplicateFailureLog := OrderedCollection with: 'In set up'.
%
category: 'running'
method: ResumableTestFailureTestCase
tearDown
	self deny: 'You should not see me' = duplicateFailureLog last
			description: 'We saw the ''You should not see me'' failure'.
	self deny: 'You should see more than me' = duplicateFailureLog last
			description: 'We did not see more than a ''You should see more than me'' failure'.
%
category: 'running'
method: ResumableTestFailureTestCase
testResumable
	| result suite |
	suite := TestSuite new.
	suite addTest: (self class selector: #errorTest).
	suite addTest: (self class selector: #regularTestFailureTest).
	suite addTest: (self class selector: #resumableTestFailureTest).
	suite addTest: (self class selector: #okTest).
	result := suite run.
	self assert: result failures size = 2;
		assert: result errors size = 1
%

errorCount

! - *** - SimpleTestResource
removeAllClassMethods SimpleTestResource
removeAllMethods SimpleTestResource
category: 'Documentation'
classMethod: SimpleTestResource
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'accessing'
classMethod: SimpleTestResource
allowAvailability
	^self _preventAvailability == nil 
%
category: 'Private'
classMethod: SimpleTestResource
preventAvailabilityName

	^(self thisClass name , '_preventAvailability') asSymbol
%
category: 'Private'
classMethod: SimpleTestResource
_preventAvailability
		"Because we can run multiple sessions, we can get conflicts on a class instance variable.
		Use SessionTemps instead"

	^SessionTemps current 
		at: self preventAvailabilityName 
		otherwise: nil.
%
category: 'Private'
classMethod: SimpleTestResource
_preventAvailability: anObject

	SessionTemps current at: self preventAvailabilityName put: anObject
%
category: 'utility'
classMethod: SimpleTestResource
preventAvailabilityDuring: aBlock

	self _preventAvailability: false.
	^aBlock ensure: [self _preventAvailability: nil]
%
category: 'accessing'
classMethod: SimpleTestResource
rawCurrentForTest
	^self _current
%
category: 'testing'
method: SimpleTestResource
hasRun
	^hasRun
%
category: 'testing'
method: SimpleTestResource
hasSetup
	^hasSetup
%
category: 'testing'
method: SimpleTestResource
isAvailable
	^self class allowAvailability and:
		[self runningState == self startedStateSymbol]
%
category: 'accessing'
method: SimpleTestResource
runningState

	^runningState
%
category: 'accessing'
method: SimpleTestResource
runningState: aSymbol

	runningState := aSymbol
%
category: 'running'
method: SimpleTestResource
setRun
	hasRun := true
%
category: 'running'
method: SimpleTestResource
setUp
	
	self runningState: self startedStateSymbol.
	hasSetup := true
%
category: 'running'
method: SimpleTestResource
startedStateSymbol

	^#started
%
category: 'running'
method: SimpleTestResource
stoppedStateSymbol

	^#stopped
%
category: 'running'
method: SimpleTestResource
tearDown

	self runningState: self stoppedStateSymbol
%

errorCount

! - *** - SimpleTestResourceA
removeAllClassMethods SimpleTestResourceA
removeAllMethods SimpleTestResourceA
category: 'Documentation'
classMethod: SimpleTestResourceA
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'accessing'
classMethod: SimpleTestResourceA
resources
	^ { SimpleTestResourceA1 . SimpleTestResourceA2 }
%

! - *** - SimpleTestResourceA1
removeAllClassMethods SimpleTestResourceA1
removeAllMethods SimpleTestResourceA1
category: 'Documentation'
classMethod: SimpleTestResourceA1
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%

! - *** - SimpleTestResourceA2
removeAllClassMethods SimpleTestResourceA2
removeAllMethods SimpleTestResourceA2
category: 'Documentation'
classMethod: SimpleTestResourceA2
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%

! - *** - SimpleTestResourceB
removeAllClassMethods SimpleTestResourceB
removeAllMethods SimpleTestResourceB
category: 'Documentation'
classMethod: SimpleTestResourceB
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'accessing'
classMethod: SimpleTestResourceB
resources
	^ { SimpleTestResourceA1 . SimpleTestResourceB1 }
%

! - *** - SimpleTestResourceB1
removeAllClassMethods SimpleTestResourceB1
removeAllMethods SimpleTestResourceB1
category: 'Documentation'
classMethod: SimpleTestResourceB1
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%

! - *** - SimpleTestResourceCircular
removeAllClassMethods SimpleTestResourceCircular
removeAllMethods SimpleTestResourceCircular
category: 'Documentation'
classMethod: SimpleTestResourceCircular
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'accessing'
classMethod: SimpleTestResourceCircular
resources
	^self _preventAvailability == nil 
		ifTrue: [super resources, { SimpleTestResourceA1 } ]
		ifFalse: [super resources, { SimpleTestResourceA1 . SimpleTestResourceCircular1 } ]
%

! - *** - SimpleTestResourceCircular1
removeAllClassMethods SimpleTestResourceCircular1
removeAllMethods SimpleTestResourceCircular1
category: 'Documentation'
classMethod: SimpleTestResourceCircular1
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'accessing'
classMethod: SimpleTestResourceCircular1
resources
	"Circular prereq:  C wants C1 which wants C."

	^ { SimpleTestResourceCircular }
%

errorCount

! - *** - SimpleTestResourceTestCase
removeAllClassMethods SimpleTestResourceTestCase
removeAllMethods SimpleTestResourceTestCase
category: 'Documentation'
classMethod: SimpleTestResourceTestCase
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'accessing'
classMethod: SimpleTestResourceTestCase
resources
	^ { SimpleTestResource }
%
category: 'utility'
method: SimpleTestResourceTestCase
clearOuterResourceStateDuring: aBlock
	"This self-testing test must clear the outer state of its resources before starting and after finishing, so that it can construct test cases and suites of itself and test them."

	self assert: SimpleTestResource isAlreadyAvailable
		description: 'The resource was not set up for the test'.
	SimpleTestResource reset.
	self deny: SimpleTestResource isAlreadyAvailable
		description: 'The resource was still set up before we began the run'.
	^aBlock sunitEnsure:
		[self deny: SimpleTestResource isAlreadyAvailable
			description: 'The resource was still set up after we finished the run'.
		SimpleTestResource isAvailable.
		self assert: SimpleTestResource isAlreadyAvailable
			description: 'The resource was not set up again after the test'].
%
category: 'private'
method: SimpleTestResourceTestCase
dummy
	self assert: resource hasSetup
		description: 'This test uses a resource but it was not set up'.
	self setRun.
	self assert: resource hasRun
		description: 'This test uses a resource but we could not interact with it'.
%
category: 'private'
method: SimpleTestResourceTestCase
error
	'foo' odd
%
category: 'private'
method: SimpleTestResourceTestCase
fail
	self assert: false
%
category: 'private'
method: SimpleTestResourceTestCase
setRun
	resource setRun
%
category: 'running'
method: SimpleTestResourceTestCase
setUp
	"Ensure that we error, not just fail, if resource is nil so that #should:raise: checks cannot mistake such an error for what they are trapping."

	resource := SimpleTestResource rawCurrentForTest.
	self deny: resource == nil 
		description: 'SimpleTestResource has no current value in test'.
	self assert: resource class == SimpleTestResource
		description: 'SimpleTestResource current is not an instance of itself'.
	self assert: resource hasSetup
		description: 'This test uses a resource but it was not set up'.
%
category: 'running'
method: SimpleTestResourceTestCase
testDebugTestWithResource
	"The debug will raise an error if the resource is not set up properly."

	self clearOuterResourceStateDuring:
		[(self class selector: #setRun) debug].
%
category: 'running'
method: SimpleTestResourceTestCase
testResourceCollection
	self assert: self class buildSuiteFromSelectors resources size = self resources size
		description: 'The suite should have the same number of resources as its test'.
	self class buildSuiteFromSelectors resources do:
		[:each |
		self assert: (self resources includes: each)
			description: each name, ':  I have this resource but my suite does not'].
%
category: 'running'
method: SimpleTestResourceTestCase
testRunSuiteWithResource
	| suite |
	suite := TestSuite new.
	suite addTest: (SimpleTestResourceTestCase selector: #error).
	suite addTest: (SimpleTestResourceTestCase selector: #fail).
	suite addTest: (self class selector: #dummy).
	self clearOuterResourceStateDuring:
		[self assert: suite run printString = '3 run, 1 passed, 1 failed, 1 error'
			description: 'A suite of tests needing SimpleTestResource did not run as expected'].
%
category: 'running'
method: SimpleTestResourceTestCase
testRunTestWithResource
	self clearOuterResourceStateDuring:
		[self assert: (self class selector: #dummy) run printString
					= '1 run, 1 passed, 0 failed, 0 errors'
			description: 'A dummy test that needed a resource did not pass'].
%

errorCount

! - *** - SUnitDelay
removeAllClassMethods SUnitDelay
removeAllMethods SUnitDelay
category: 'Documentation'
classMethod: SUnitDelay
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%

! - *** - SUnitNameResolver
removeAllClassMethods SUnitNameResolver
removeAllMethods SUnitNameResolver
category: 'Documentation'
classMethod: SUnitNameResolver
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'SUnit'
classMethod: SUnitNameResolver
classNamed: aSymbol

	| assoc |
	(assoc := System myUserProfile resolveSymbol: aSymbol) == nil ifTrue: [^nil].
	^assoc value.
%
category: 'SUnit'
classMethod: SUnitNameResolver
defaultLogDevice

	^WriteStream on: String new.
%
category: 'SUnit'
classMethod: SUnitNameResolver
errorObject
	^Error
%
category: 'SUnit'
classMethod: SUnitNameResolver
mnuExceptionObject
	^MessageNotUnderstood new
%
category: 'SUnit'
classMethod: SUnitNameResolver
notificationObject
	^Notification new
%

errorCount

! - *** - SUnitTest
removeAllClassMethods SUnitTest
removeAllMethods SUnitTest
category: 'Documentation'
classMethod: SUnitTest
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'private'
method: SUnitTest
assertForTestResult: aResult runCount: aRunCount passed: aPassedCount failed: aFailureCount errors: anErrorCount

	self
		assert: aResult runCount = aRunCount;
		assert: aResult passedCount = aPassedCount;
		assert: aResult failureCount = aFailureCount;
		assert: aResult errorCount = anErrorCount
%
category: 'private'
method: SUnitTest
error
	3 zork
%
category: 'testing'
method: SUnitTest
errorShouldntRaise
	self 
		shouldnt: [self someMessageThatIsntUnderstood] 
		raise: SUnitNameResolver notificationObject
%
category: 'private'
method: SUnitTest
fail
	self assert: false
%
category: 'accessing'
method: SUnitTest
hasRun
	^hasRun
%
category: 'accessing'
method: SUnitTest
hasSetup
	^hasSetup
%
category: 'private'
method: SUnitTest
noop
%
category: 'private'
method: SUnitTest
setRun
	hasRun := true
%
category: 'running'
method: SUnitTest
setUp
	hasSetup := true
%
category: 'testing'
method: SUnitTest
testAssert
	self assert: true.
	self deny: false
%
category: 'testing'
method: SUnitTest
testDefects
	| result suite error failure |
	suite := TestSuite new.
	suite addTest: (error := self class selector: #error).
	suite addTest: (failure := self class selector: #fail).
	result := suite run.
	self assert: result defects asArray = { error . failure } .
	self
		assertForTestResult: result
		runCount: 2
		passed: 0
		failed: 1
		errors: 1
%
category: 'testing'
method: SUnitTest
testDialectLocalizedException

	self
		should: [TestResult signalFailureWith: 'Foo']
		raise: TestResult failure.
	self
		should: [TestResult signalErrorWith: 'Foo']
		raise: TestResult error.
%
category: 'testing'
method: SUnitTest
testError

	| case result |

	case := self class selector: #error.
	result := case run.
	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 0
		errors: 1.

	case := self class selector: #errorShouldntRaise.
	result := case run.
	self 
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 0
		errors: 1
%
category: 'testing'
method: SUnitTest
testException

	self
		should: [self error: 'foo']
		raise: TestResult error
%
category: 'testing'
method: SUnitTest
testFail

	| case result |

	case := self class selector: #fail.
	result := case run.

	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 1
		errors: 0
%
category: 'testing'
method: SUnitTest
testIsNotRerunOnDebug

	| case |

	case := self class selector: #testRanOnlyOnce.
	case run.
	case debug
%
category: 'testing'
method: SUnitTest
testRan

	| case |

	case := self class selector: #setRun.
	case run.
	self assert: case hasSetup.
	self assert: case hasRun
%
category: 'testing'
method: SUnitTest
testRanOnlyOnce

	self assert: hasRanOnce ~= true.
	hasRanOnce := true
%
category: 'testing'
method: SUnitTest
testResult

	| case result |

	case := self class selector: #noop.
	result := case run.

	self
		assertForTestResult: result
		runCount: 1
		passed: 1
		failed: 0
		errors: 0
%
category: 'testing'
method: SUnitTest
testRunning

	(SUnitDelay forSeconds: 2) wait
%
category: 'testing'
method: SUnitTest
testShould

	self
		should: [true];
		shouldnt: [false]
%
category: 'testing'
method: SUnitTest
testSuite

	| suite result |

	suite := TestSuite new.
	suite 
		addTest: (self class selector: #noop);
		addTest: (self class selector: #fail);
		addTest: (self class selector: #error).

	result := suite run.

	self
		assertForTestResult: result
		runCount: 3
		passed: 1
		failed: 1
		errors: 1
%

errorCount

! - *** - TestAsserter
removeAllClassMethods TestAsserter
removeAllMethods TestAsserter
category: 'Documentation'
classMethod: TestAsserter
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'other'
classMethod: TestAsserter
assert: aBoolean description: aString
	aBoolean ifFalse:
		[self logFailure: aString.
		TestResult failure signal: aString].
%
category: 'other'
classMethod: TestAsserter
failureLog
	^SUnitNameResolver defaultLogDevice
%
category: 'other'
classMethod: TestAsserter
isLogging
	"By default, we're not logging failures. Override in subclasses as desired."

	^false
%
category: 'other'
classMethod: TestAsserter
logFailure: aString
	self isLogging ifTrue: 
		[self failureLog cr; nextPutAll: aString; flush].
%
category: 'other'
method: TestAsserter
assert: aBoolean
	aBoolean ifFalse:
		[self logFailure: 'Assertion failed'.
		TestResult failure signal: 'Assertion failed'].
%
category: 'other'
method: TestAsserter
assert: aBoolean description: aString
	aBoolean ifFalse:
		[self logFailure: aString.
		TestResult failure signal: aString].
%
category: 'other'
method: TestAsserter
assert: aBoolean description: aString resumable: resumableBoolean
	| exception |
	aBoolean ifFalse:
		[self logFailure: aString.
		exception := resumableBoolean
			ifTrue: [TestResult resumableFailure]
			ifFalse: [TestResult failure].
		exception signal: aString].
%
category: 'other'
method: TestAsserter
assert: anObject equals: otherObj
	self
		assert: anObject = otherObj
		description: anObject printString , ' is not equal to ' , otherObj printString.
%
category: 'other'
method: TestAsserter
deny: aBoolean
	self assert: aBoolean not.
%
category: 'other'
method: TestAsserter
deny: aBoolean description: aString
	self assert: aBoolean not description: aString.
%
category: 'other'
method: TestAsserter
deny: aBoolean description: aString resumable: resumableBoolean
	self assert: aBoolean not description: aString resumable: resumableBoolean.
%
category: 'other'
method: TestAsserter
deny: anObject equals: anotherObject
	self
		deny: anObject = anotherObject
		description: anObject printString , ' is equal to ' , anotherObject printString.
%
category: 'other'
method: TestAsserter
executeShould: aBlock inScopeOf: anObject 

	| expectedErrorNumber |
	(anObject isKindOf: Integer)
		ifTrue: [expectedErrorNumber := anObject]
		ifFalse: 
			[(anObject isKindOf: Symbol)
				ifTrue: [expectedErrorNumber := ErrorSymbols at: anObject]
				ifFalse: 
					[^
					[aBlock value.
					false] sunitOn: anObject do: [:ex | ^true]]].
	^
	[aBlock value.
	false] sunitOn: Error
			do: [:ex | expectedErrorNumber = ex number ifTrue: [^true] ifFalse: [ex pass]]
%
category: 'other'
method: TestAsserter
logFailure: aString
	self class logFailure: aString.
%
category: 'other'
method: TestAsserter
should: aBlock raise: anObject

	| expectedErrorNumber actualErrorNumber |
	(anObject isKindOf: Integer) ifTrue: [
		expectedErrorNumber := anObject.
	] ifFalse: [(anObject isKindOf: Symbol) ifTrue: [
		expectedErrorNumber := ErrorSymbols at: anObject.
	] ifFalse: [
		^self assert: (self executeShould: aBlock inScopeOf: anObject).
	]].
	aBlock on: Error do: [:ex | 
	   actualErrorNumber := ex number.
	].
	self should: [actualErrorNumber = expectedErrorNumber].
%
category: 'other'
method: TestAsserter
should: aBlock raise: anExceptionalEvent description: aString 
	self 
		assert: (self executeShould: aBlock inScopeOf: anExceptionalEvent)
		description: aString
%
category: 'other'
method: TestAsserter
shouldnt: aBlock raise: anExceptionalEvent 
	self assert: (self executeShould: aBlock inScopeOf: anExceptionalEvent) not.
%
category: 'other'
method: TestAsserter
shouldnt: aBlock raise: anExceptionalEvent description: aString 
	self
		assert: (self executeShould: aBlock inScopeOf: anExceptionalEvent) not
 		description: aString.
%

errorCount

! - *** - TestCase

expectvalue /Class
doit
TestCase comment: 
'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'
%
expectvalue /Class
doit
TestCase category: 'SUnit-Kernel'
%
! ------------------- Remove existing behavior from TestCase
expectvalue /Metaclass3       
doit
TestCase removeAllMethods.
TestCase class removeAllMethods.
%
set compile_env: 0
! ------------------- Class methods for TestCase
category: 'Accessing'
classmethod: TestCase
allTestSelectors
	| answer pivotClass lookupRoot |
	answer := Set withAll: self testSelectors.
	self shouldInheritSelectors
		ifTrue:
			[pivotClass := self.
			lookupRoot := self lookupHierarchyRoot.
			[pivotClass == lookupRoot]
				whileFalse:
					[pivotClass := pivotClass superclass.
					answer addAll: pivotClass testSelectors]].
	^answer asSortedCollection asOrderedCollection
%
category: 'Building Suites'
classmethod: TestCase
buildSuite
	| suite |
	^self isAbstract
		ifTrue: 
			[suite := self suiteClass named: self name asString.
			self allSubclasses 
				do: [:each | each isAbstract ifFalse: [suite addTest: each buildSuiteFromSelectors]].
			suite]
		ifFalse: [self buildSuiteFromSelectors]
%
category: 'Building Suites'
classmethod: TestCase
buildSuiteFromMethods: testMethods

	^testMethods
		inject: (self suiteClass named: self name asString)
		into: [:suite :selector |
			suite
				addTest: (self selector: selector);
				yourself]
%
category: 'Building Suites'
classmethod: TestCase
buildSuiteFromSelectors
	^self buildSuiteFromMethods: self allTestSelectors
%
category: 'Running'
classmethod: TestCase
debug

	^self suite debug
%
category: 'Instance Creation'
classmethod: TestCase
debug: aSymbol

	^(self selector: aSymbol) debug
%
category: 'Testing'
classmethod: TestCase
isAbstract
	"Override to true if a TestCase subclass is Abstract and should not have
	TestCase instances built from it"

	^self sunitName = #TestCase
%
category: 'Accessing'
classmethod: TestCase
lookupHierarchyRoot
	^TestCase
%
category: 'Accessing'
classmethod: TestCase
resources

	^#()
%
category: 'Running'
classmethod: TestCase
run

	^self suite run
%
category: 'Instance Creation'
classmethod: TestCase
run: aSymbol

	^(self selector: aSymbol) run
%
category: 'Instance Creation'
classmethod: TestCase
selector: aSymbol

	^self new setTestSelector: aSymbol
%
category: 'Testing'
classmethod: TestCase
shouldInheritSelectors
	"I should inherit from an Abstract superclass but not from a concrete one by default, unless I have no testSelectors in which case I must be expecting to inherit them from my superclass.  If a test case with selectors wants to inherit selectors from a concrete superclass, override this to true in that subclass."
	
	^self ~~ self lookupHierarchyRoot
		and: [self superclass isAbstract 
			or: [self testSelectors isEmpty]]
%
category: 'Instance Creation'
classmethod: TestCase
suite

	^self buildSuite
%
category: 'Building Suites'
classmethod: TestCase
suiteClass
	^TestSuite
%
category: 'Accessing'
classmethod: TestCase
sunitVersion
	^'4.0'
%
category: 'Accessing'
classmethod: TestCase
testSelectors

	^self sunitSelectors select: [:each | 'test*' sunitMatch: each]
%
! ------------------- Instance methods for TestCase
category: 'Dependencies'
method: TestCase
addDependentToHierachy: anObject 
	"an empty method. for Composite compability with TestSuite"
%
category: 'Running'
method: TestCase
debug
	[(self class selector: testSelector) runCase]
		ensure: [TestResource resetResources: self resources]
%
category: 'Running'
method: TestCase
debugAsFailure
	| semaphore |
	semaphore := Semaphore new.
	[semaphore wait.
	TestResource resetResources: self resources] fork.
	(self class selector: testSelector) runCaseAsFailure: semaphore
%
category: 'Running'
method: TestCase
openDebuggerOnFailingTestMethod
	"SUnit has halted one step in front of the failing test method. Step over the 'self halt' and 
	 send into 'self perform: testSelector' to see the failure from the beginning"

	self
		halt;
		performTest
%
category: 'Private'
method: TestCase
performTest
	self perform: testSelector asSymbol
%
category: 'Printing'
method: TestCase
printOn: aStream

	aStream
		nextPutAll: self class printString;
		nextPutAll: ' debug: #';
		nextPutAll: (testSelector isNil ifTrue: ['??'] ifFalse: [testSelector])
%
category: 'Dependencies'
method: TestCase
removeDependentFromHierachy: anObject 
	"an empty method. for Composite compability with TestSuite"
%
category: 'Accessing'
method: TestCase
resources
	"We give TestCase this instance-side method so that methods polymorphic with TestSuite can be code-identical.  Having this instance-side method also helps when writing tests of resource behaviour. Except for such tests, it is rare to override this method and should not be done without thought.  If there were a good reason why a single test case needed to share tests requiring different resources, it might be legitimate."

	^self class resources
%
category: 'Running'
method: TestCase
run
	| result |
	result := TestResult new.
	[self run: result]
		ensure: [TestResource resetResources: self resources].
	^result
%
category: 'Running'
method: TestCase
run: aResult
	aResult runCase: self
%
category: 'Running'
method: TestCase
runCase
	| tornDown |
	self resources do: [:each | each availableFor: self].
	[ self setUp.
	  self performTest
        ] ensure: [
	  tornDown ifNil:[ 
		tornDown := true .
		self tearDown
	  ]
        ]
%
category: 'Running'
method: TestCase
runCaseAsFailure: aSemaphore
	[self resources do: [:each | each availableFor: self].
	[self setUp.
	self openDebuggerOnFailingTestMethod] ensure: [self tearDown]]
		ensure: [aSemaphore signal]
%
category: 'Accessing'
method: TestCase
selector
	^testSelector
%
category: 'Private'
method: TestCase
setTestSelector: aSymbol
	testSelector := aSymbol
%
category: 'Private'
method: TestCase
setUp
%
category: 'Testing'
method: TestCase
should: aBlock
	self assert: aBlock value
%
category: 'Testing'
method: TestCase
should: aBlock description: aString
	self assert: aBlock value description: aString
%
category: 'Testing'
method: TestCase
shouldnt: aBlock
	self deny: aBlock value
%
category: 'Testing'
method: TestCase
shouldnt: aBlock description: aString
	self deny: aBlock value description: aString
%
category: 'Testing'
method: TestCase
signalFailure: aString
	TestResult failure sunitSignalWith: aString
%
category: 'Running'
method: TestCase
tearDown
%

errorCount

! - *** - TestFailure
removeAllClassMethods TestFailure
removeAllMethods TestFailure
category: 'Documentation'
classMethod: TestFailure
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'other'
method: TestFailure
sunitAnnounce: aTestCase toResult: aTestResult
	aTestResult addFailure: aTestCase.
	self sunitExitWith: false.
%
! fix 43411
category: 'Instance initialization'
method: TestFailure
initialize
  gsNumber := ERR_TestFailure .
  gsResumable := true .
  gsTrappable := true .
%

errorCount

! - *** - TestResource
removeAllClassMethods TestResource
removeAllMethods TestResource
category: 'Documentation'
classMethod: TestResource
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'Running'
classMethod: TestResource
availableFor: aTestAsserter
	aTestAsserter
		assert: self isAvailable
		description:
			'Unavailable resource ' , self name , ' requested by '
				, aTestAsserter printString
%
category: 'Accessing'
classMethod: TestResource
current
	"This is a lazy accessor:  the assert of self isAvailable does no work unless current isNil.  However this method should normally be sent only to a resource that should already have been made available, e.g. in a test whose test case class has the resource class in its #resources, so should never be able to fail the assert.
	If the intent is indeed to access a possibly-unprepared or reset-in-earlier-test resource lazily, then preface the call of 'MyResource current' with 'MyResource availableFor: self'."
	
	self
		assert: self isAvailable
		description:
			'Sent #current to unavailable resource ' , self name ,
					'.  Add it to test case'' class-side #resources (recommended) or send #availableFor: beforehand'.
	^self _current
%
category: 'Accessing'
classMethod: TestResource
current: aTestResource

	self _current: aTestResource.
%
category: 'Testing'
classMethod: TestResource
isAbstract
	"Override to true if a TestResource subclass is Abstract and should not have
	TestCase instances built from it"

	^self name = #TestResource
%
category: 'Testing'
classMethod: TestResource
isAlreadyAvailable
	^self _current class == self
%
category: 'Testing'
classMethod: TestResource
isAvailable
	"This is (and must be) a lazy method.  If my current has a value, an attempt to make me available has already been made:  trust its result.  If not, try to make me available."

	self _current == nil  ifTrue: [self makeAvailable].
	^self isAlreadyAvailable
%
category: 'Creation'
classMethod: TestResource
makeAvailable
	"This method must be the _only_ way to set a notNil value for the unique instance (current).  First, obtain a candidate instance and set current to a notNil placeholder (any notNil object not an instance of me would do;  this version uses false).  Next, check any subordinate resources needed by this resource.  Lastly, setUp the candidate and put it in current if it is available, ensuring that it is torn down otherwise."
	
	| candidate |
	self _current: false.
	candidate := self new.
	self resources do: [:each | each availableFor: candidate].
	[candidate setUp.
	candidate isAvailable ifTrue: [self _current: candidate]]
		ensure: [self _current == candidate ifFalse: [candidate tearDown]]
%
category: 'Creation'
classMethod: TestResource
new
	"Use #current to get the valid current instance.  Use of #new to get an instance (that should never be the current one) could be done in bizarre circumstances, so is not blocked, but will usually be inappropriate."
	
	^super new initialize.
%
category: 'Creation'
classMethod: TestResource
reset
	[self isAlreadyAvailable ifTrue: [self _current tearDown]]
		ensure: [self _current: nil]
%
category: 'Private'
classMethod: TestResource
resetOrAddResourcesTo: aCollection
	"Add correctly set-up resources to the collection unless already there. Reset any imperfectly-set-up resources, so current isNil will return true if they are re-encountered via an indirectly self-prerequing resource;  circular references cannot be set up so will never reply true to isAlreadyAvailable, but may have correctly-set-up prereqs to add and/or imperfectly-set-up ones to reset, so do not abort the loop first time round."

	self _current == nil  ifTrue: [^self].
	self isAlreadyAvailable
		ifFalse:
			[self reset.
			self resources do: [:each | each resetOrAddResourcesTo: aCollection]]
		ifTrue:
			[(aCollection includes: self)
				ifFalse:
					[self resources do: [:each | each resetOrAddResourcesTo: aCollection].
					aCollection add: self]]

"The cloned 'self resources do: ...' line in both blocks is, I think, the best way to write this method so that its logic is clear.  The first loop resets this resource immediately, before traversing its resources;  the second traverses before adding"
%
category: 'Running'
classMethod: TestResource
resetResources: topLevelResources
	"Reset all imperfectly-set-up resources while gathering the rest for ordered resetting."

	| availableResources |
	availableResources := OrderedCollection new: topLevelResources size.
	topLevelResources
		do: [:each | each resetOrAddResourcesTo: availableResources].
	availableResources reverseDo: [:each | each reset]
%
category: 'Accessing'
classMethod: TestResource
resources
	^#()
%
category: 'Private'
classMethod: TestResource
currentName

	^(self thisClass name , '_current') asSymbol
%
category: 'Private'
classMethod: TestResource
_current
		"Because we can run multiple sessions, we can get conflicts on a class instance variable.
		Use SessionTemps instead"

	^SessionTemps current 
		at: self currentName 
		otherwise: nil.
%
category: 'Private'
classMethod: TestResource
_current: aTestResource

	SessionTemps current at: self currentName put: aTestResource
%
category: 'Accessing'
method: TestResource
description

	description == nil 
		ifTrue: [^''].

	^description
%
category: 'Accessing'
method: TestResource
description: aString

	description := aString
%
category: 'Init / Release'
method: TestResource
initialize
	"This method used to call setUp but now does nothing;  setUp is called by the framework at the appropriate point.  Subclasses may override to set the object to its default state."
%
category: 'Testing'
method: TestResource
isAvailable
	"Override to provide information on the readiness of the resource.  Put state-changing behaviour in setUp and keep this a state-preserving check as far as possible.  Where setUp is guaranteed to provide a valid resource if it completes, there is no need to override this."
	
	^true
%
category: 'Accessing'
method: TestResource
name

	name == nil 
		ifTrue: [^self printString].

	^name
%
category: 'Accessing'
method: TestResource
name: aString

	name := aString
%
category: 'Printing'
method: TestResource
printOn: aStream

	aStream nextPutAll: self class printString
%
category: 'Accessing'
method: TestResource
resources
	^self class resources
%
category: 'Running'
method: TestResource
setUp
	"Does nothing. Subclasses should override this to initialize their resource"
%
category: 'Running'
method: TestResource
tearDown
	"Does nothing. Subclasses should override this to tear down their resource"
%

errorCount

! - *** - TestResult
removeAllClassMethods TestResult
removeAllMethods TestResult
category: 'Documentation'
classMethod: TestResult
comment
^'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'.
%
category: 'Exceptions'
classMethod: TestResult
error
	^self exError
%
category: 'Exceptions'
classMethod: TestResult
exError
	^SUnitNameResolver errorObject
%
category: 'Exceptions'
classMethod: TestResult
failure
	^TestFailure
%
category: 'Init / Release'
classMethod: TestResult
new
	^super new initialize
%
category: 'Exceptions'
classMethod: TestResult
resumableFailure
	^ResumableTestFailure
%
category: 'Exceptions'
classMethod: TestResult
signalErrorWith: aString 
	self error sunitSignalWith: aString
%
category: 'Exceptions'
classMethod: TestResult
signalFailureWith: aString 
	self failure sunitSignalWith: aString
%
category: 'Adding'
method: TestResult
addError: aTestCase
	"We cannot use self errors as that incorporates test expectations and so does not return the stored collection."

	^self errors add: aTestCase
%
category: 'Adding'
method: TestResult
addFailure: aTestCase
	"We cannot use self failures as that incorporates test expectations and so does not return the stored collection."

	^self failures add: aTestCase
%
category: 'Adding'
method: TestResult
addPass: aTestCase
	"We cannot use self passed as that incorporates test expectations and so does not return the stored collection."

	^self passed add: aTestCase
%
category: 'Deprecated'
method: TestResult
correctCount
	"deprecated - use #passedCount"

	self deprecated: 'TestResult>>correctCount deprecated v3.2, use passedCount instead'.
	^self passedCount
%
category: 'Accessing'
method: TestResult
defects
	^OrderedCollection new
		addAll: self errors;
		addAll: self failures; yourself
%
category: 'Accessing'
method: TestResult
errorCount

	^self errors size
%
category: 'Accessing'
method: TestResult
errors

	errors == nil 
		ifTrue: [errors := OrderedCollection new].
	^errors
%
category: 'Accessing'
method: TestResult
failureCount

	^self failures size
%
category: 'Accessing'
method: TestResult
failures
	"We use a Set, not an OrderedCollection as #errors and #passed do, because a resumable test failure in a loop can raise many failures against the same test. In current SUnit UIs, this could result in bizarre test count reporting (-27 tests run, and suchlike). This will be reviewed."

	failures ifNil: [failures := Set new].
	^failures
%
category: 'Testing'
method: TestResult
hasErrors

	^self errors size > 0
%
category: 'Testing'
method: TestResult
hasFailures

	^self failures size > 0
%
category: 'Testing'
method: TestResult
hasPassed

	^self hasErrors not and: [self hasFailures not]
%
category: 'Init / Release'
method: TestResult
initialize
%
category: 'Testing'
method: TestResult
isError: aTestCase

	^self errors includes: aTestCase
%
category: 'Testing'
method: TestResult
isFailure: aTestCase
	^self failures includes: aTestCase
%
category: 'Testing'
method: TestResult
isPassed: aTestCase

	^self passed includes: aTestCase
%
category: 'Accessing'
method: TestResult
passed

	passed == nil 
		ifTrue: [passed := OrderedCollection new].

	^passed
%
category: 'Accessing'
method: TestResult
passedCount

	^self passed size
%
category: 'Printing'
method: TestResult
printOn: aStream

	aStream
		nextPutAll: self runCount printString;
		nextPutAll: ' run, ';
		nextPutAll: self passedCount printString;
		nextPutAll: ' passed, ';
		nextPutAll: self failureCount printString;
		nextPutAll: ' failed, ';
		nextPutAll: self errorCount printString;
		nextPutAll: ' error'.

	self errorCount ~= 1
		ifTrue: [aStream nextPut: $s]
%
category: 'Running'
method: TestResult
runCase: aTestCase
	[aTestCase runCase.
	self addPass: aTestCase]
		on: self class failure , self class error
		do: [:ex | ex sunitAnnounce: aTestCase toResult: self]
%
category: 'Accessing'
method: TestResult
runCount

	^self passedCount + self failureCount + self errorCount
%
category: 'Accessing'
method: TestResult
tests
	^(OrderedCollection new: self runCount)
		addAll: passed;
		addAll: failures;
		addAll: errors;
		yourself
%

errorCount

! - *** - TestSuite

expectvalue /Class
doit
TestSuite comment: 
'This class is part of the community-maintained SUnit framework  
documented at http://sunit.sourceforge.net. The current version is  
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz'. 
% 
expectvalue /Class
doit
TestSuite category: 'SUnit-Kernel'
%

! ------------------- Remove existing behavior from TestSuite
expectvalue /Metaclass3 
doit
TestSuite removeAllMethods.
TestSuite class removeAllMethods.
%
set compile_env: 0
! ------------------- Class methods for TestSuite
category: 'Creation'
classmethod: TestSuite
named: aString

	^self new
		name: aString;
		yourself
%
! ------------------- Instance methods for TestSuite
category: 'Dependencies'
method: TestSuite
addDependentToHierachy: anObject
	self sunitAddDependent: anObject.
	self tests do: [ :each | each addDependentToHierachy: anObject]
%
category: 'Accessing'
method: TestSuite
addTest: aTest
	self tests add: aTest
%
category: 'Accessing'
method: TestSuite
addTests: aCollection 
	aCollection do: [:eachTest | self addTest: eachTest]
%
category: 'Running'
method: TestSuite
debug

	self tests do: [:each | each debug]
%
category: 'Accessing'
method: TestSuite
defaultResources
	^self tests
		inject: OrderedCollection new
		into:
			[:coll :testCase |
			testCase resources do:
				[:each |
				(coll includes: each) ifFalse: [coll add: each]].
			coll]
%
category: 'Accessing'
method: TestSuite
name

	^name
%
category: 'Accessing'
method: TestSuite
name: aString

	name := aString
%
category: 'Dependencies'
method: TestSuite
removeDependentFromHierachy: anObject
	self sunitRemoveDependent: anObject.
	self tests do: [ :each | each removeDependentFromHierachy: anObject]
%
category: 'Accessing'
method: TestSuite
resources
	resources == nil  ifTrue: [resources := self defaultResources].
	^resources
%
category: 'Accessing'
method: TestSuite
resources: someOrderedTestResourceClasses
	"The parameter should understand reverseDo: and should not contain duplicates."

	resources := someOrderedTestResourceClasses
%
category: 'Running'
method: TestSuite
run
	| result |
	result := TestResult new.
	[self run: result]
		ensure: [TestResource resetResources: self resources].
	^result
%
category: 'Running'
method: TestSuite
run: aResult 
	self tests do: [:each | 
		self sunitChanged: each.
		each run: aResult]
%
category: 'Accessing'
method: TestSuite
tests
	tests == nil  ifTrue: [tests := OrderedCollection new].
	^tests
%

errorCount

! - *** - loose methods (where class is expected to be already defined)

category: '*SUnit'
method: Behavior
sunitAllSelectors 
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

self deprecated: 'Behavior>>sunitAllSelectors is deprecated v3.0. This method has no 
senders in current SUnit.  Use allTestSelectors (and in rare cases, testSelectors).  
Any dialect-specific use that might exist in some SUnit extensions should inline 
their dialect-specific implementation.'.
	^self allSelectors asSortedCollection asOrderedCollection
%
category: '*SUnit'
method: Behavior
sunitSelectors
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"
 
        ^self selectors asSortedCollection asOrderedCollection
%
category: '*SUnit'
method: BlockClosure
sunitEnsure: aBlock 
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^self ensure: aBlock
%
category: '*SUnit'
method: BlockClosure
sunitOn: aSignal do: anExceptionBlock 
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^self on: aSignal do: anExceptionBlock
%
category: '*SUnit'
method: Class
sunitName
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

        ^self name
%
category: '*SUnit-Preload'
method: Error
sunitAnnounce: aTestCase toResult: aTestResult
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	aTestResult addError: aTestCase.
	self sunitExitWith: false.
%
category: '*SUnit'
method: Exception
sunitExitWith: aValue
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^self return: aValue
%
category: '*SUnit'
method: Exception
sunitSignalWith: aString
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^self signal: aString
%
category: '*SUnit'
method: Object
sunitAddDependent: anObject
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	"GemStone does nothing!"
%
category: '*SUnit'
method: Object
sunitChanged: anAspect
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	"GemStone does nothing!"
%
category: '*SUnit'
method: Object
sunitRemoveDependent: anObject
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	"GemStone does nothing!"
%
category: '*SUnit'
method: String
sunitAsSymbol
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

        ^self asSymbol
%
category: '*SUnit'
method: String
sunitMatch: aString
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	| pattern |
	pattern := OrderedCollection new.
	(self notEmpty and: [self first == $* ]) ifTrue: [
		pattern add: $*.
	].
	(self subStrings: $*) do: [:each | 
		pattern
			add: each;
			add: $*.
	].
	(self notEmpty and: [self last ~~ $* ]) ifTrue: [
		pattern removeLast.
	].
	^aString matchPattern: pattern asArray.
%
category: '*SUnit'
method: String
sunitSubStrings
"This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	self deprecated: 'Behavior>>sunitSubStrings is deprecated v3.0. This method has 
no senders in current SUnit. Any dialect-specific use that might exist in some SUnit 
extensions should inline their dialect-specific implementation.'.
	^self subStrings
%
category: '*SUnit'
method: Symbol
sunitAsClass
 "This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^SUnitNameResolver classNamed: self
%
method: DoubleByteSymbol
sunitAsClass
 "This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^SUnitNameResolver classNamed: self
%
method: QuadByteSymbol
sunitAsClass
 "This method is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^SUnitNameResolver classNamed: self
%

errorCount
