!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id:abstractindexspec.gs 19139 2008-05-30 23:48:14Z stever $
!
! Superclass Hierarchy:
!   AbstractIndexSpecification,
!   Object.
!
!=========================================================================

! class created in idxclasses.topaz

! Remove existing behavior from AbstractIndexSpecification
doit
AbstractIndexSpecification removeAllMethods.
AbstractIndexSpecification class removeAllMethods.
true
%

! ------------------- Class methods for AbstractIndexSpecification
category: 'For Documentation Installation only'
classmethod: AbstractIndexSpecification
installDocumentation

self comment:
'AbstractIndexSpecification is an abstract superclass for classes that are used to specify 
the details for creating indexes. Concrete classes are used to create Equality Indexes, 
Identity Indexes, and other refinements of these indexes.

Instance variables:
path -- String describing the path of the index
lastElementClass -- Class of the last element on the path, only used for Equality indexes
requirePathTerms -- Boolean, if it is allowed for elements in the indexed collection to 
  not have an instance variable matching a term on the path.

'.
%

category: 'instance creation'
classmethod: AbstractIndexSpecification
path: aString lastElementClass: aClass

	^(self new)
		path: aString;
		lastElementClass: aClass;
		yourself
%
! ------------------- Instance methods for AbstractIndexSpecification
category: 'accessing'
method: AbstractIndexSpecification
indexType

	^ self subclassResponsibility: #indexType
%
category: 'accessing'
method: AbstractIndexSpecification
lastElementClass

	^lastElementClass
%
category: 'accessing'
method: AbstractIndexSpecification
lastElementClass: aClass 

	lastElementClass := aClass
%
category: 'accessing'
method: AbstractIndexSpecification
path

	^path
%
category: 'accessing'
method: AbstractIndexSpecification
path: aString 

	path := aString
%
category: 'accessing'
set compile_env: 0
method: AbstractIndexSpecification
createIndexOn: anNsc
  IndexManager current createIndexFor: anNsc fromSpec: self
%
category: 'accessing'
set compile_env: 0
method: AbstractIndexSpecification
indexTypePrintString
  self subclassResponsibility: #'indexTypePrintString'
%
category: 'printing'
set compile_env: 0
method: AbstractIndexSpecification
printSelectorOn: aStream

  aStream nextPutAll: self indexTypePrintString.
  self path isEmpty
    ifTrue: [ aStream nextPutAll: ': ''''' ]
    ifFalse: [ aStream nextPutAll: ': ''each.' , self path , '''' ].
  self lastElementClass ifNotNil: [ :cls | aStream
        lf;
        tab;
        tab;
        nextPutAll: 'lastElementClass: ' , cls name asString ].
  self collator ifNotNil: [ :icuColl | aStream
        lf;
        tab;
        tab;
        nextPutAll:
            'collator: (IcuCollator forLocaleNamed: ' , icuColl locale name printString
                , ')' ].
  self printOptionsSelectorOn: aStream
%
category: 'accessing'
set compile_env: 0
method: AbstractIndexSpecification
removeIndexFrom: anNsc
  (self isIndexedOn: anNsc)
    ifTrue: [ anNsc removeEqualityIndexOn: self path ]
%
category: 'accessing'
set compile_env: 0
method: AbstractIndexSpecification
requirePathTerms: aBool
  requirePathTerms := aBool
%
category: 'testing'
set compile_env: 0
method: AbstractIndexSpecification
isIndexedOn: anNsc
  ^ (anNsc _findIndexesWithPath: self path asArrayOfPathTerms) isEmpty not
%
category: 'accessing'
set compile_env: 0
method: AbstractIndexSpecification
_createIndex
  self subclassResponsibility: #'_createIndex'
%
category: 'private'
set compile_env: 0
method: AbstractIndexSpecification
_validateLastElementClassOn: anNsc
  "noop"

  
%
category: 'private'
set compile_env: 0
method: AbstractIndexSpecification
_validatePathOn: anNsc
  anNsc _checkIndexPathExpression: self path
%
category: 'private'
set compile_env: 0
method: AbstractIndexSpecification
_validateSpecificationOn: anNsc
  self _validateLastElementClassOn: anNsc.
  self _validatePathOn: anNsc
%
category: 'accessing'
set compile_env: 0
method: AbstractIndexSpecification
defaultPathTermClass
  ^ self requirePathTerms
    ifTrue: [ self legacyIndex
        ifTrue: [ PathTerm ]
        ifFalse: [ GsPathTerm ] ]
    ifFalse: [ self legacyIndex
        ifTrue: [ OptionalPathTerm ]
        ifFalse: [ GsOptionalPathTerm ] ]
%
category: 'accessing'
set compile_env: 0
method: AbstractIndexSpecification
requirePathTerms
  requirePathTerms ifNil: [ requirePathTerms := true ].
  ^ requirePathTerms
%
category: 'accessing'
set compile_env: 0
method: AbstractIndexSpecification
collator
  "No collator associate with non-Unicode indexes"

  ^ nil
%
category: 'accessing'
set compile_env: 0
method: AbstractIndexSpecification
options
  | options |
  options := GsIndexOptions basicNew.
  self reducedConflict
    ifTrue: [ options setReducedConflict ]
    ifFalse: [ options clearReducedConflict ].
  self optionalPathTerms
    ifTrue: [ options setOptionalPathTerms ]
    ifFalse: [ options clearOptionalPathTerms ].
  self legacyIndex
    ifTrue: [ 
      options setLegacyIndex.
      options clearBtreePlusIndex.
      options clearOptimizedComparison "by definition" ]
    ifFalse: [
      options setBtreePlusIndex. 
      options clearLegacyIndex.
      "optimized comparisons only apply to btreePlus index"
      self optimizedComparison
        ifTrue: [ options setOptimizedComparison ]
        ifFalse: [ options clearOptimizedComparison ] ].
  ^ options
%
category: 'accessing'
method: AbstractIndexSpecification
optionalPathTerms
  ^ self requirePathTerms not
%
category: 'accessing'
method: AbstractIndexSpecification
optionalPathTerms: aBool
  self requirePathTerms: aBool not
%
category: 'accessing'
method: AbstractIndexSpecification
defaultEnumeratedPathTermClass
  ^ self legacyIndex
    ifTrue: [ EnumeratedPathTerm ]
    ifFalse: [ GsEnumeratedPathTerm ]
%
category: 'accessing'
method: AbstractIndexSpecification
defaultSelectorPathTermClass
  ^ self legacyIndex
    ifTrue: [ SelectorPathTerm ]
    ifFalse: [ GsSelectorPathTerm ]
%
category: 'accessing'
method: AbstractIndexSpecification
defaultSetValuedPathTermClass
  ^ self legacyIndex
    ifTrue: [ SetValuedPathTerm ]
    ifFalse: [ GsSetValuedPathTerm ]
%
category: 'accessing'
method: AbstractIndexSpecification
legacyIndex
  | val |
  val := self dynamicInstVarAt: #'legacyIndex'.
  ^ val ifNil: [ true ]
%
category: 'accessing'
method: AbstractIndexSpecification
legacyIndex: aBool
  self dynamicInstVarAt: #'legacyIndex' put: aBool
%
category: 'accessing'
method: AbstractIndexSpecification
optimizedComparison
  | val |
  val := self dynamicInstVarAt: #'optimizedComparison'.
  ^ val ifNil: [ false ]
%
category: 'accessing'
method: AbstractIndexSpecification
optimizedComparison: aBool
  self dynamicInstVarAt: #'optimizedComparison' put: aBool
%
category: 'accessing'
method: AbstractIndexSpecification
options: aGsIndexOptions
  self optionalPathTerms: aGsIndexOptions optionalPathTerms.
  self reducedConflict: aGsIndexOptions reducedConflict.
  self legacyIndex: aGsIndexOptions legacyIndex.
  self optimizedComparison: aGsIndexOptions optimizedComparison
%
category: 'accessing'
method: AbstractIndexSpecification
reducedConflict
  | val |
  val := self dynamicInstVarAt: #'reducedConflict'.
  ^ val ifNil: [ false ]
%
category: 'accessing'
method: AbstractIndexSpecification
reducedConflict: aBool
  self dynamicInstVarAt: #'reducedConflict' put: aBool
%
category: 'printing'
method: AbstractIndexSpecification
printOptionsSelectorOn: aStream
  aStream
    lf;
    tab;
    tab;
    nextPutAll: 'options: '.
  self options printOn: aStream
%
